/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade.domain;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.ActivityParameters;

public class RemoveDomainInActivityUpgradePlugin
extends UpgradeProductPlugin {
    public static final String URL_KEY = "page_url";
    private static final Log LOG = ExoLogger.getLogger(RemoveDomainInActivityUpgradePlugin.class);

    public RemoveDomainInActivityUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"\n\nStart check wiki activities...\n");
        try {
            this.removeDomainNameInActivityParams();
        }
        catch (Exception e) {
            LOG.warn((Object)"[WikiRemoveDomainNameInURLPlugin] Exception when fix null url for wiki page:", (Throwable)e);
        }
        LOG.info((Object)"\n\nFinish ...\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void removeDomainNameInActivityParams() {
        LOG.info((Object)"removing hostname of page url in activity param ....");
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        ChromatticSession session = this.getSocialChromatticLifeCycle().getSession();
        QueryResult activityParamIterator = session.createQueryBuilder(ActivityParameters.class).where("page_url IS NOT NULL").get().objects();
        int count = 0;
        int nbOfParam = activityParamIterator.size();
        while (activityParamIterator.hasNext()) {
            ActivityParameters param = (ActivityParameters)activityParamIterator.next();
            Map templateParams = param.getParams();
            String oldActivityURL = (String)templateParams.get(URL_KEY);
            LOG.info("Old wiki activity url:", new Object[]{oldActivityURL});
            if (oldActivityURL == null) continue;
            try {
                URL oldURL = new URL(oldActivityURL);
                String newURL = oldURL.getPath();
                LOG.info("new wiki activity url:", new Object[]{newURL});
                templateParams.put(URL_KEY, newURL);
                LOG.info("\nFixed activity: {}/{}\n", new Object[]{++count, nbOfParam});
            }
            catch (MalformedURLException e) {
                LOG.info((Object)"exception when parsing url in removeDomainNameInActivityParams", (Throwable)e);
            }
        }
        RequestLifeCycle.end();
    }

    private SocialChromatticLifeCycle getSocialChromatticLifeCycle() {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        return (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
    }
}

