/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.common.ext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

public final class UIExtensionUtils {
    private static final Log logger = ExoLogger.getLogger((String)"cs.common.ext.UIExtensionUtils");

    public static Map<String, UIComponent> getComponents(String extensionType, UIContainer parent, Map<String, Object> context) {
        List extensions;
        HashMap<String, UIComponent> components = new HashMap<String, UIComponent>();
        UIExtensionManager manager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstance(UIExtensionManager.class);
        if (manager != null && (extensions = manager.getUIExtensions(extensionType)) != null) {
            for (UIExtension extension : extensions) {
                try {
                    UIComponent component = manager.addUIExtension(extension, context, parent);
                    if (component == null) continue;
                    components.put(extension.getName(), component);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("failed to get ui component of uiextension: type=" + extensionType), (Throwable)e);
                }
            }
        }
        return components;
    }
}

