/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.key;

import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.cache.model.ScopeCacheKey;

public class PostKey
extends ScopeCacheKey {
    private final String category;
    private final String forum;
    private final String topic;
    private final String post;

    public PostKey(String category, String forum, String topic, String post) {
        this.category = category;
        this.forum = forum;
        this.topic = topic;
        this.post = post;
    }

    public PostKey(Post post) {
        this.category = null;
        this.forum = post.getForumId();
        this.topic = post.getTopicId();
        this.post = post.getId();
    }

    public String getCategory() {
        return this.category;
    }

    public String getForum() {
        return this.forum;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getPost() {
        return this.post;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostKey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PostKey postKey = (PostKey)o;
        if (this.category != null ? !this.category.equals(postKey.category) : postKey.category != null) {
            return false;
        }
        if (this.forum != null ? !this.forum.equals(postKey.forum) : postKey.forum != null) {
            return false;
        }
        if (this.post != null ? !this.post.equals(postKey.post) : postKey.post != null) {
            return false;
        }
        return !(this.topic != null ? !this.topic.equals(postKey.topic) : postKey.topic != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.forum != null ? this.forum.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
        return result;
    }
}

