/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.search;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.forum.service.ForumSearch;

public class UnifiedSearchOrder {
    public static List<ForumSearch> processOrder(List<ForumSearch> listSearchResult, String sort, String order) {
        RelavancyCompatator comparator = new RelavancyCompatator(sort, order);
        Collections.sort(listSearchResult, comparator);
        return listSearchResult;
    }

    static class RelavancyCompatator
    implements Comparator<ForumSearch> {
        private String sort;
        private String order;

        public RelavancyCompatator(String sort, String order) {
            this.sort = sort;
            this.order = order;
        }

        @Override
        public int compare(ForumSearch o1, ForumSearch o2) {
            if ("relevancy".equalsIgnoreCase(this.sort) && "ASC".equalsIgnoreCase(this.order)) {
                return o1.getRelevancy().compareTo(o2.getRelevancy());
            }
            if ("relevancy".equalsIgnoreCase(this.sort) && "DESC".equalsIgnoreCase(this.order)) {
                return o2.getRelevancy().compareTo(o1.getRelevancy());
            }
            if ("title".equalsIgnoreCase(this.sort) && "ASC".equalsIgnoreCase(this.order)) {
                return o1.getName().toUpperCase().compareTo(o2.getName().toUpperCase());
            }
            if ("title".equalsIgnoreCase(this.sort) && "DESC".equalsIgnoreCase(this.order)) {
                return o2.getName().toUpperCase().compareTo(o1.getName().toUpperCase());
            }
            if ("date".equalsIgnoreCase(this.sort) && "ASC".equalsIgnoreCase(this.order)) {
                return o1.getCreatedDate().compareTo(o2.getCreatedDate());
            }
            if ("date".equalsIgnoreCase(this.sort) && "DESC".equalsIgnoreCase(this.order)) {
                return o2.getCreatedDate().compareTo(o1.getCreatedDate());
            }
            return 0;
        }
    }
}

