/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractValueData
implements ValueData {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.AbstractValueData");
    protected int orderNumber;

    protected AbstractValueData(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public final int getOrderNumber() {
        return this.orderNumber;
    }

    public boolean isByteArray() {
        return true;
    }

    public byte[] getAsByteArray() throws IOException {
        return this.spoolInternalValue();
    }

    public InputStream getAsStream() throws IOException {
        return new ByteArrayInputStream(this.getAsByteArray());
    }

    public long getLength() {
        try {
            return this.getAsByteArray().length;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't calculate the length of value", e);
        }
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        if (this.isByteArray()) {
            return this.readFromByteArray(stream, length, position);
        }
        throw new IllegalStateException("Method is not supported for ValueData represented in array of bytes");
    }

    protected long readFromByteArray(OutputStream stream, long length, long position) throws IOException {
        byte[] data = this.getAsByteArray();
        length = this.validateAndAdjustLenght(length, position, data.length);
        stream.write(data, (int)position, (int)length);
        return length;
    }

    protected long validateAndAdjustLenght(long length, long position, long dataLength) throws IOException {
        if (position < 0L) {
            throw new IOException("Position must be higher or equals 0. But given " + position);
        }
        if (length < 0L) {
            throw new IOException("Length must be higher or equals 0. But given " + length);
        }
        if (position >= dataLength && position > 0L) {
            throw new IOException("Position " + position + " out of value size " + dataLength);
        }
        if (position + length >= dataLength) {
            return dataLength - position;
        }
        return length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueData) {
            return this.equals((ValueData)obj);
        }
        return false;
    }

    public boolean equals(ValueData another) {
        ValueData valueData = another;
        if (another instanceof TransientValueData) {
            return another.equals(this);
        }
        if (valueData instanceof AbstractValueData) {
            return this == valueData || this.internalEquals(valueData);
        }
        return false;
    }

    protected abstract TransientValueData createTransientCopy(int var1) throws IOException;

    protected abstract PersistedValueData createPersistedCopy(int var1) throws IOException;

    protected abstract byte[] spoolInternalValue();

    protected abstract boolean internalEquals(ValueData var1);

    protected Long getLong() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to Long. Wrong value type.");
    }

    protected Boolean getBoolean() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to Boolean. Wrong value type.");
    }

    protected Double getDouble() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to Double. Wrong value type.");
    }

    protected Calendar getDate() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to Calendar. Wrong value type.");
    }

    protected InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.spoolInternalValue());
    }

    protected InternalQName getName() throws IllegalNameException, ValueFormatException {
        throw new ValueFormatException("Can't conver to InternalQName. Wrong value type.");
    }

    protected QPath getPath() throws IllegalPathException, ValueFormatException {
        throw new ValueFormatException("Can't conver to QPath. Wrong value type.");
    }

    protected String getReference() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to Identity. Wrong value type.");
    }

    protected AccessControlEntry getPermission() throws ValueFormatException {
        throw new ValueFormatException("Can't conver to AccessControlEntry. Wrong value type.");
    }

    protected abstract String getString() throws ValueFormatException;
}

