/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.CQJDBCStorageConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleDbJDBCConnection
extends CQJDBCStorageConnection {
    protected static final String FIND_NODES_BY_PARENTID_CQ_QUERY = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SITEM P, JCR_SVALUE V where I.I_CLASS=1 and I.CONTAINER_NAME=? and I.PARENT_ID=? and P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
    protected static final String FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_SITEM I LEFT OUTER JOIN JCR_SVALUE V ON (V.PROPERTY_ID=I.ID) where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.PARENT_ID=? order by I.NAME";
    protected static final String FIND_ITEM_QPATH_BY_ID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.I_INDEX from JCR_SITEM I, (SELECT ID, PARENT_ID from JCR_SITEM where ID=?) J where I.ID = J.ID or I.ID = J.PARENT_ID";
    protected static final String PATTERN_ESCAPE_STRING = "\\";

    public SingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected String getInternalId(String identifier) {
        return this.containerConfig.containerName + identifier;
    }

    @Override
    protected String getIdentifier(String internalId) {
        if (internalId == null) {
            return null;
        }
        return internalId.substring(this.containerConfig.containerName.length());
    }

    @Override
    protected void prepareQueries() throws SQLException {
        this.FIND_ITEM_BY_ID = "select * from JCR_SITEM where ID=?";
        this.FIND_ITEM_BY_NAME = "select * from JCR_SITEM I where CONTAINER_NAME=? and PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.PARENT_ID=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_REFERENCES = "select P.ID, P.PARENT_ID, P.VERSION, P.P_TYPE, P.P_MULTIVALUED, P.NAME from JCR_SREF R, JCR_SITEM P where R.NODE_ID=? and P.CONTAINER_NAME=? and P.ID=R.PROPERTY_ID and P.I_CLASS=2";
        this.FIND_VALUES_BY_PROPERTYID = "select PROPERTY_ID, ORDER_NUM, DATA, STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=? order by ORDER_NUM";
        this.FIND_VALUES_VSTORAGE_DESC_BY_PROPERTYID = "select distinct STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=?";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=? order by N_ORDER_NUM";
        this.FIND_NODES_BY_PARENTID_CQ = FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = "select I.NAME, V.DATA, V.ORDER_NUM from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.PARENT_ID=? and (I.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or I.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and I.ID=V.PROPERTY_ID";
        this.FIND_ITEM_QPATH_BY_ID_CQ = FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME=? and PARENT_ID=? order by NAME";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_SITEM I LEFT OUTER JOIN JCR_SVALUE V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SITEM P, JCR_SVALUE V";
        this.FIND_MAX_PROPERTY_VERSIONS = "select max(VERSION) FROM JCR_SITEM WHERE PARENT_ID=? and CONTAINER_NAME=? and NAME=? and I_INDEX=? and I_CLASS=2";
        this.INSERT_NODE = "insert into JCR_SITEM(ID, PARENT_ID, NAME, CONTAINER_NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES(?,?,?,?,?,1,?,?)";
        this.INSERT_PROPERTY = "insert into JCR_SITEM(ID, PARENT_ID, NAME, CONTAINER_NAME, VERSION, I_CLASS, I_INDEX, P_TYPE, P_MULTIVALUED) VALUES(?,?,?,?,?,2,?,?,?)";
        this.INSERT_VALUE = "insert into JCR_SVALUE(DATA, ORDER_NUM, PROPERTY_ID, STORAGE_DESC) VALUES(?,?,?,?)";
        this.INSERT_REF = "insert into JCR_SREF(NODE_ID, PROPERTY_ID, ORDER_NUM) VALUES(?,?,?)";
        this.RENAME_NODE = "update JCR_SITEM set PARENT_ID=?, NAME=?, VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_NODE = "update JCR_SITEM set VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_PROPERTY = "update JCR_SITEM set VERSION=?, P_TYPE=? where ID=?";
        this.DELETE_ITEM = "delete from JCR_SITEM where ID=?";
        this.DELETE_VALUE = "delete from JCR_SVALUE where PROPERTY_ID=?";
        this.DELETE_REF = "delete from JCR_SREF where PROPERTY_ID=?";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID LIMIT ? OFFSET ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";
        this.FIND_PROPERTY_BY_ID = "select I.P_TYPE, V.STORAGE_DESC from JCR_SITEM I, JCR_SVALUE V where I.ID = ? and V.PROPERTY_ID = I.ID";
        this.DELETE_VALUE_BY_ORDER_NUM = "delete from JCR_SVALUE where PROPERTY_ID=? and ORDER_NUM >= ?";
        this.DELETE_REFERENCE_BY_ORDER_NUM = "delete from JCR_SREF where PROPERTY_ID=? and ORDER_NUM >= ?";
        this.UPDATE_VALUE = "update JCR_SVALUE set DATA=?, STORAGE_DESC=? where PROPERTY_ID=? and ORDER_NUM=?";
        this.UPDATE_REFERENCE = "update JCR_SREF set NODE_ID=? where PROPERTY_ID=? and ORDER_NUM=?";
        this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SITEM P, JCR_SVALUE V where I.I_CLASS=1 and I.CONTAINER_NAME=? and I.PARENT_ID=? and I.N_ORDER_NUM >= ? and  I.N_ORDER_NUM <= ? and P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_ACL_HOLDERS = "select I.PARENT_ID, I.P_TYPE from JCR_SITEM I where I.I_CLASS=2 and I.CONTAINER_NAME=? and (I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')";
        this.FIND_NODES_COUNT = "select count(*) from JCR_SITEM I where I.I_CLASS=1 and I.CONTAINER_NAME=?";
    }

    @Override
    protected int addNodeRecord(NodeData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertNode == null) {
            this.insertNode = this.dbConnection.prepareStatement(this.INSERT_NODE);
        } else {
            this.insertNode.clearParameters();
        }
        this.insertNode.setString(1, this.getInternalId(data.getIdentifier()));
        this.insertNode.setString(2, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : this.getInternalId(data.getParentIdentifier()));
        this.insertNode.setString(3, data.getQPath().getName().getAsString());
        this.insertNode.setString(4, this.containerConfig.containerName);
        this.insertNode.setInt(5, data.getPersistedVersion());
        this.insertNode.setInt(6, data.getQPath().getIndex());
        this.insertNode.setInt(7, data.getOrderNumber());
        return this.executeUpdate(this.insertNode, 32);
    }

    @Override
    protected int addPropertyRecord(PropertyData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertProperty == null) {
            this.insertProperty = this.dbConnection.prepareStatement(this.INSERT_PROPERTY);
        } else {
            this.insertProperty.clearParameters();
        }
        this.insertProperty.setString(1, this.getInternalId(data.getIdentifier()));
        this.insertProperty.setString(2, this.getInternalId(data.getParentIdentifier()));
        this.insertProperty.setString(3, data.getQPath().getName().getAsString());
        this.insertProperty.setString(4, this.containerConfig.containerName);
        this.insertProperty.setInt(5, data.getPersistedVersion());
        this.insertProperty.setInt(6, data.getQPath().getIndex());
        this.insertProperty.setInt(7, data.getType());
        this.insertProperty.setBoolean(8, data.isMultiValued());
        return this.executeUpdate(this.insertProperty, 64);
    }

    @Override
    protected int addReference(PropertyData data) throws SQLException, IOException, InvalidItemStateException, RepositoryException {
        List<ValueData> values = data.getValues();
        int added = 0;
        for (int i = 0; i < values.size(); ++i) {
            String refNodeIdentifier;
            ValueData vdata = values.get(i);
            try {
                refNodeIdentifier = ValueDataUtil.getString(vdata);
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
            added += this.addReference(this.getInternalId(data.getIdentifier()), i, this.getInternalId(refNodeIdentifier));
        }
        return added;
    }

    @Override
    protected int deleteReferenceByOrderNum(String id, int orderNum) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteReferenceByOrderNum == null) {
            this.deleteReferenceByOrderNum = this.dbConnection.prepareStatement(this.DELETE_REFERENCE_BY_ORDER_NUM);
        } else {
            this.deleteReferenceByOrderNum.clearParameters();
        }
        this.deleteReferenceByOrderNum.setString(1, id);
        this.deleteReferenceByOrderNum.setInt(2, orderNum);
        return this.executeUpdate(this.deleteReferenceByOrderNum, 131072);
    }

    @Override
    protected int addReference(String cid, int i, String refNodeIdentifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertReference == null) {
            this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
        } else {
            this.insertReference.clearParameters();
        }
        this.insertReference.setString(1, refNodeIdentifier);
        this.insertReference.setString(2, cid);
        this.insertReference.setInt(3, i);
        return this.executeUpdate(this.insertReference, 128);
    }

    @Override
    protected int updateReference(String cid, int i, String refNodeIdentifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateReference == null) {
            this.updateReference = this.dbConnection.prepareStatement(this.UPDATE_REFERENCE);
        } else {
            this.updateReference.clearParameters();
        }
        this.updateReference.setString(1, refNodeIdentifier);
        this.updateReference.setString(2, cid);
        this.updateReference.setInt(3, i);
        return this.executeUpdate(this.updateReference, 4096);
    }

    @Override
    protected int deleteReference(String propertyCid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteReference == null) {
            this.deleteReference = this.dbConnection.prepareStatement(this.DELETE_REF);
        } else {
            this.deleteReference.clearParameters();
        }
        this.deleteReference.setString(1, propertyCid);
        return this.executeUpdate(this.deleteReference, 16384);
    }

    @Override
    protected int deleteItemByIdentifier(String cid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteItem == null) {
            this.deleteItem = this.dbConnection.prepareStatement(this.DELETE_ITEM);
        } else {
            this.deleteItem.clearParameters();
        }
        this.deleteItem.setString(1, cid);
        return this.executeUpdate(this.deleteItem, 8192);
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, this.containerConfig.containerName);
        this.findNodesByParentId.setString(2, parentCid);
        return this.findNodesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, this.containerConfig.containerName);
        this.findLastOrderNumberByParentId.setString(2, parentIdentifier);
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesCountByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, this.containerConfig.containerName);
        this.findNodesCountByParentId.setString(2, parentCid);
        return this.findNodesCountByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, this.containerConfig.containerName);
        this.findPropertiesByParentId.setString(2, parentCid);
        return this.findPropertiesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, this.containerConfig.containerName);
        this.findItemByName.setString(2, parentId);
        this.findItemByName.setString(3, name);
        this.findItemByName.setInt(4, index);
        return this.findItemByName.executeQuery();
    }

    @Override
    protected ResultSet findPropertyByName(String parentCid, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, this.containerConfig.containerName);
        this.findPropertyByName.setString(2, parentCid);
        this.findPropertyByName.setString(3, name);
        return this.findPropertyByName.executeQuery();
    }

    @Override
    protected ResultSet findItemByIdentifier(String cid) throws SQLException {
        if (this.findItemById == null) {
            this.findItemById = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_ID);
        } else {
            this.findItemById.clearParameters();
        }
        this.findItemById.setString(1, cid);
        return this.findItemById.executeQuery();
    }

    @Override
    protected ResultSet findReferences(String cid) throws SQLException {
        if (this.findReferences == null) {
            this.findReferences = this.dbConnection.prepareStatement(this.FIND_REFERENCES);
        } else {
            this.findReferences.clearParameters();
        }
        this.findReferences.setString(1, cid);
        this.findReferences.setString(2, this.containerConfig.containerName);
        return this.findReferences.executeQuery();
    }

    @Override
    protected int updateNodeByIdentifier(int version, int index, int orderNumb, String cid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateNode == null) {
            this.updateNode = this.dbConnection.prepareStatement(this.UPDATE_NODE);
        } else {
            this.updateNode.clearParameters();
        }
        this.updateNode.setInt(1, version);
        this.updateNode.setInt(2, index);
        this.updateNode.setInt(3, orderNumb);
        this.updateNode.setString(4, cid);
        return this.executeUpdate(this.updateNode, 512);
    }

    @Override
    protected int updatePropertyByIdentifier(int version, int type, String cid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateProperty == null) {
            this.updateProperty = this.dbConnection.prepareStatement(this.UPDATE_PROPERTY);
        } else {
            this.updateProperty.clearParameters();
        }
        this.updateProperty.setInt(1, version);
        this.updateProperty.setInt(2, type);
        this.updateProperty.setString(3, cid);
        return this.executeUpdate(this.updateProperty, 1024);
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int toOrderNum) throws SQLException {
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, this.containerConfig.containerName);
        this.findNodesByParentIdLazilyCQ.setString(2, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(3, fromOrderNum);
        this.findNodesByParentIdLazilyCQ.setInt(4, toOrderNum);
        this.findNodesByParentIdLazilyCQ.setString(5, this.containerConfig.containerName);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    @Override
    protected int addValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertValue == null) {
            this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        } else {
            this.insertValue.clearParameters();
        }
        if (stream == null) {
            this.insertValue.setNull(1, -2);
            this.insertValue.setString(4, storageDesc);
        } else {
            this.insertValue.setBinaryStream(1, stream, streamLength);
            this.insertValue.setNull(4, 12);
        }
        this.insertValue.setInt(2, orderNumber);
        this.insertValue.setString(3, cid);
        return this.executeUpdate(this.insertValue, 256);
    }

    @Override
    protected int deleteValueData(String cid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteValue == null) {
            this.deleteValue = this.dbConnection.prepareStatement(this.DELETE_VALUE);
        } else {
            this.deleteValue.clearParameters();
        }
        this.deleteValue.setString(1, cid);
        return this.executeUpdate(this.deleteValue, 32768);
    }

    @Override
    protected ResultSet findValuesByPropertyId(String cid) throws SQLException {
        if (this.findValuesByPropertyId == null) {
            this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        } else {
            this.findValuesByPropertyId.clearParameters();
        }
        this.findValuesByPropertyId.setString(1, cid);
        return this.findValuesByPropertyId.executeQuery();
    }

    @Override
    protected ResultSet findValuesStorageDescriptorsByPropertyId(String cid) throws SQLException {
        if (this.findValuesStorageDescriptorsByPropertyId == null) {
            this.findValuesStorageDescriptorsByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_VSTORAGE_DESC_BY_PROPERTYID);
        } else {
            this.findValuesStorageDescriptorsByPropertyId.clearParameters();
        }
        this.findValuesStorageDescriptorsByPropertyId.setString(1, cid);
        return this.findValuesStorageDescriptorsByPropertyId.executeQuery();
    }

    @Override
    protected int renameNode(NodeData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.renameNode == null) {
            this.renameNode = this.dbConnection.prepareStatement(this.RENAME_NODE);
        } else {
            this.renameNode.clearParameters();
        }
        this.renameNode.setString(1, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : this.getInternalId(data.getParentIdentifier()));
        this.renameNode.setString(2, data.getQPath().getName().getAsString());
        this.renameNode.setInt(3, data.getPersistedVersion());
        this.renameNode.setInt(4, data.getQPath().getIndex());
        this.renameNode.setInt(5, data.getOrderNumber());
        this.renameNode.setString(6, this.getInternalId(data.getIdentifier()));
        return this.executeUpdate(this.renameNode, 262144);
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentIdCQ == null) {
            this.findNodesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_CQ);
        } else {
            this.findNodesByParentIdCQ.clearParameters();
        }
        this.findNodesByParentIdCQ.setString(1, this.containerConfig.containerName);
        this.findNodesByParentIdCQ.setString(2, parentIdentifier);
        this.findNodesByParentIdCQ.setString(3, this.containerConfig.containerName);
        return this.findNodesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findNodesByParentIdAndComplexPatternCQ == null) {
            this.findNodesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=1 and I.CONTAINER_NAME='");
        query.append(this.containerConfig.containerName);
        query.append("' and I.PARENT_ID='");
        query.append(parentIdentifier);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), true);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), true);
        }
        query.append(" ) and P.I_CLASS=2 and P.CONTAINER_NAME='");
        query.append(this.containerConfig.containerName);
        query.append("' and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType'");
        query.append(" or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')");
        query.append(" and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID");
        return this.findNodesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentIdCQ == null) {
            this.findPropertiesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findPropertiesByParentIdCQ.clearParameters();
        }
        this.findPropertiesByParentIdCQ.setString(1, this.containerConfig.containerName);
        this.findPropertiesByParentIdCQ.setString(2, parentIdentifier);
        return this.findPropertiesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentCid, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findPropertiesByParentIdAndComplexPatternCQ == null) {
            this.findPropertiesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=2 and I.CONTAINER_NAME='");
        query.append(this.containerConfig.containerName);
        query.append("' and I.PARENT_ID='");
        query.append(parentCid);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), false);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), false);
        }
        query.append(" ) order by I.NAME");
        return this.findPropertiesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findNodeMainPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodeMainPropertiesByParentIdentifierCQ == null) {
            this.findNodeMainPropertiesByParentIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findNodeMainPropertiesByParentIdentifierCQ.clearParameters();
        }
        this.findNodeMainPropertiesByParentIdentifierCQ.setString(1, this.containerConfig.containerName);
        this.findNodeMainPropertiesByParentIdentifierCQ.setString(2, parentIdentifier);
        return this.findNodeMainPropertiesByParentIdentifierCQ.executeQuery();
    }

    @Override
    protected ResultSet findItemQPathByIdentifierCQ(String identifier) throws SQLException {
        if (this.findItemQPathByIdentifierCQ == null) {
            this.findItemQPathByIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_ITEM_QPATH_BY_ID_CQ);
        } else {
            this.findItemQPathByIdentifierCQ.clearParameters();
        }
        this.findItemQPathByIdentifierCQ.setString(1, identifier);
        return this.findItemQPathByIdentifierCQ.executeQuery();
    }

    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.containerConfig.containerName);
        this.findNodesAndProperties.setString(2, this.getInternalId(lastNodeId));
        this.findNodesAndProperties.setInt(3, limit);
        this.findNodesAndProperties.setInt(4, offset);
        this.findNodesAndProperties.setString(5, this.containerConfig.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    @Override
    protected int deleteValueDataByOrderNum(String id, int orderNum) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteValueDataByOrderNum == null) {
            this.deleteValueDataByOrderNum = this.dbConnection.prepareStatement(this.DELETE_VALUE_BY_ORDER_NUM);
        } else {
            this.deleteValueDataByOrderNum.clearParameters();
        }
        this.deleteValueDataByOrderNum.setString(1, id);
        this.deleteValueDataByOrderNum.setInt(2, orderNum);
        return this.executeUpdate(this.deleteValueDataByOrderNum, 65536);
    }

    @Override
    protected ResultSet findPropertyById(String id) throws SQLException {
        if (this.findPropertyById == null) {
            this.findPropertyById = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_ID);
        } else {
            this.findPropertyById.clearParameters();
        }
        this.findPropertyById.setString(1, id);
        return this.findPropertyById.executeQuery();
    }

    @Override
    protected int updateValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateValue == null) {
            this.updateValue = this.dbConnection.prepareStatement(this.UPDATE_VALUE);
        } else {
            this.updateValue.clearParameters();
        }
        if (stream == null) {
            this.updateValue.setNull(1, -2);
            this.updateValue.setString(2, storageDesc);
        } else {
            this.updateValue.setBinaryStream(1, stream, streamLength);
            this.updateValue.setNull(2, 12);
        }
        this.updateValue.setString(3, cid);
        this.updateValue.setInt(4, orderNumber);
        return this.executeUpdate(this.updateValue, 2048);
    }

    protected String fixEscapeSymbols(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbold());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    protected void appendPattern(StringBuilder sb, QPathEntry entry, boolean indexConstraint) {
        String pattern = entry.getAsString(false);
        sb.append("(I.NAME");
        if (pattern.contains("*")) {
            sb.append(" LIKE '");
            sb.append(this.fixEscapeSymbols(pattern));
            sb.append("' ESCAPE '");
            sb.append(this.getLikeExpressionEscape());
            sb.append("'");
        } else {
            sb.append("='");
            sb.append(pattern);
            sb.append("'");
        }
        if (indexConstraint && entry.getIndex() != -1) {
            sb.append(" and I.I_INDEX=");
            sb.append(entry.getIndex());
        }
        sb.append(")");
    }

    protected String getWildcardEscapeSymbold() {
        return PATTERN_ESCAPE_STRING;
    }

    protected String getLikeExpressionEscape() {
        return PATTERN_ESCAPE_STRING;
    }

    @Override
    protected ResultSet findACLHolders() throws SQLException {
        if (this.findACLHolders == null) {
            this.findACLHolders = this.dbConnection.prepareStatement(this.FIND_ACL_HOLDERS);
        } else {
            this.findACLHolders.clearParameters();
        }
        this.findACLHolders.setString(1, this.containerConfig.containerName);
        return this.findACLHolders.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteLockProperties() throws SQLException, InvalidItemStateException, RepositoryException {
        SQLException e22;
        Statement removeItemsStatement;
        block11: {
            this.addChange(16);
            PreparedStatement removeValuesStatement = null;
            removeItemsStatement = null;
            try {
                removeValuesStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SVALUE WHERE PROPERTY_ID IN (SELECT ID FROM JCR_SITEM WHERE CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner'))");
                removeValuesStatement.setString(1, this.containerConfig.containerName);
                removeItemsStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SITEM WHERE CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner')");
                removeItemsStatement.setString(1, this.containerConfig.containerName);
                removeValuesStatement.executeUpdate();
                removeItemsStatement.executeUpdate();
                Object var4_3 = null;
                if (removeValuesStatement == null) break block11;
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var4_4 = null;
                if (removeValuesStatement != null) {
                    try {
                        removeValuesStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                if (removeItemsStatement != null) {
                    try {
                        removeItemsStatement.close();
                    }
                    catch (SQLException e22) {
                        LOG.error((Object)"Can't close statement", (Throwable)e22);
                    }
                }
                throw throwable;
            }
            try {
                removeValuesStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
        if (removeItemsStatement != null) {
            try {
                removeItemsStatement.close();
            }
            catch (SQLException e22) {
                LOG.error((Object)"Can't close statement", (Throwable)e22);
            }
        }
    }

    @Override
    protected ResultSet findNodesCount() throws SQLException {
        if (this.findNodesCount == null) {
            this.findNodesCount = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT);
        } else {
            this.findNodesCount.clearParameters();
        }
        this.findNodesCount.setString(1, this.containerConfig.containerName);
        return this.findNodesCount.executeQuery();
    }

    @Override
    protected ResultSet findMaxPropertyVersion(String parentId, String name, int index) throws SQLException {
        if (this.findMaxPropertyVersions == null) {
            this.findMaxPropertyVersions = this.dbConnection.prepareStatement(this.FIND_MAX_PROPERTY_VERSIONS);
        }
        this.findMaxPropertyVersions.setString(1, this.getInternalId(parentId));
        this.findMaxPropertyVersions.setString(2, this.containerConfig.containerName);
        this.findMaxPropertyVersions.setString(3, name);
        this.findMaxPropertyVersions.setInt(4, index);
        return this.findMaxPropertyVersions.executeQuery();
    }
}

