/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.tex;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.PrintTextListener;
import org.xwiki.rendering.wikimodel.ReferenceHandler;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.images.ImageUtil;

public class TexSerializer
extends PrintTextListener {
    private static int tableCount = 0;
    int[] cols = new int[]{3, 4, 4, 4, 3, 3, 3, 5, 5, 3, 5, 3, 4, 3, 3, 3, 0, 0, 0, 0, 0};
    private String documentName;
    private DocumentContext fContext;
    private Stack<DocumentContext> fContextStack = new Stack();
    private String imageTargetFolder;
    private String wikiFileDownloadBaseUrl;

    public static String processString(String g, boolean flag) {
        String[] array1 = new String[]{"\\s", "\u00e9", "\u00e8", "\u00ea", "\u00e0", "\u00f4", "\u00f9"};
        String[] array2 = new String[]{"_", "eacute;", "eagrave;", "ecicr;", "aacute;", "ocirc;", "ugrave;"};
        if (flag) {
            for (int i = 0; i < array1.length; ++i) {
                g = g.replaceAll(array1[i], array2[i]);
            }
            return g;
        }
        for (int i = 1; i < array1.length; ++i) {
            g = g.replaceAll(array2[i], array1[i]);
        }
        return g;
    }

    public TexSerializer(IWikiPrinter printer, String documentName, String wikiFileDownloadBaseUrl, String imageTargetFolderPath) {
        super(printer);
        this.documentName = documentName;
        this.imageTargetFolder = imageTargetFolderPath;
        this.wikiFileDownloadBaseUrl = wikiFileDownloadBaseUrl;
    }

    @Override
    public void beginDocument(WikiParameters params) {
        this.fContext = new DocumentContext();
        this.fContextStack.push(this.fContext);
    }

    @Override
    public void beginHeader(int headerLevel, WikiParameters params) {
        this.println();
        this.print("\\");
        if (headerLevel == 1) {
            this.print("chapter{");
        } else if (headerLevel < 4) {
            for (int i = 1; i < headerLevel - 1; ++i) {
                this.print("sub");
            }
            this.print("section{");
        } else {
            this.print("paragraph{");
        }
    }

    @Override
    public void beginList(WikiParameters parameters, boolean ordered) {
        this.println("\\begin{itemize}");
    }

    @Override
    public void beginListItem() {
        this.print(" \\item ");
    }

    @Override
    public void beginParagraph(WikiParameters params) {
        this.println("");
    }

    @Override
    public void beginTable(WikiParameters params) {
        this.println("\\begin{center}");
        this.println("\\begin{footnotesize}");
        String colwidth = "3";
        if (this.cols[tableCount] > 3) {
            colwidth = "2";
        }
        this.print("\\begin{tabular}{");
        for (int i = 0; i < this.cols[tableCount] + 1; ++i) {
            this.print("|p{" + colwidth + "cm}");
        }
        this.println("|}\\hline");
        this.fContext.fTableHead = true;
        ++tableCount;
    }

    @Override
    public void beginTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "" : "";
        this.print(str + params);
        if (tableHead) {
            this.fContext.fTableHeadCell = true;
        }
        if (!this.fContext.fFirstRowCell) {
            this.print("&");
        }
        this.fContext.fFirstRowCell = false;
    }

    @Override
    public void beginTableRow(WikiParameters params) {
        if (this.fContext.fTableHead) {
            this.print("");
        } else {
            this.print("");
        }
        this.fContext.fFirstRowCell = true;
    }

    @Override
    public void endDocument(WikiParameters params) {
        this.fContextStack.pop();
        this.fContext = !this.fContextStack.empty() ? this.fContextStack.peek() : null;
    }

    @Override
    public void endHeader(int headerLevel, WikiParameters params) {
        this.println("}");
    }

    @Override
    public void endList(WikiParameters parameters, boolean ordered) {
        this.println("\\end{itemize}");
    }

    @Override
    public void endListItem() {
        this.println("");
    }

    @Override
    public void endParagraph(WikiParameters params) {
        this.println("");
    }

    @Override
    public void endQuotationLine() {
        this.println("");
    }

    @Override
    public void endTable(WikiParameters params) {
        this.println("\\end{tabular}");
        this.println("\\end{footnotesize}");
        this.println("\\end{center}");
    }

    @Override
    public void endTableCell(boolean tableHead, WikiParameters params) {
        if (tableHead) {
            this.print("}");
        }
    }

    @Override
    public void endTableRow(WikiParameters params) {
        this.println("\\\\\\hline");
        this.fContext.fTableHead = false;
    }

    protected InputStream getImageInput(String ref) throws IOException {
        File f = new File(this.imageTargetFolder + ref);
        if (!f.exists()) {
            FileOutputStream fos = new FileOutputStream(f);
            String url = this.wikiFileDownloadBaseUrl + this.documentName + "/" + ref;
            System.out.println("Downloading image " + url + " to " + f.getAbsolutePath() + "...");
            try {
                WGet wget = new WGet();
                wget.fetchURL(url, fos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fos.flush();
            fos.close();
        }
        FileInputStream fis = new FileInputStream(f);
        return fis;
    }

    protected int[] getImageSize(String ref) {
        int[] result = null;
        try {
            InputStream input = this.getImageInput(ref);
            if (input != null) {
                int maxWidth = this.getMaxImageWidth();
                int maxHeight = this.getMaxImageHeight();
                return ImageUtil.getImageSize(input, maxWidth, maxHeight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected int getMaxImageHeight() {
        return 2000;
    }

    protected int getMaxImageWidth() {
        return 2000;
    }

    @Override
    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(true, true){
            Map<String, int[]> fImageSizes;
            {
                this.fImageSizes = new HashMap<String, int[]>();
            }

            @Override
            protected void handleImage(String ref, String label, WikiParameters params) {
                String caption = "";
                int idx = ref.indexOf("===caption===");
                if (idx > 0) {
                    caption = ref.substring(idx + 13, ref.length() - 13);
                    caption = caption.replaceAll("_", " ");
                    caption = TexSerializer.processString(caption, false);
                    ref = ref.substring(0, idx);
                    label = ref.substring(0, ref.length() - 4);
                }
                int[] size = TexSerializer.this.getImageSize(ref);
                TexSerializer.this.println();
                TexSerializer.this.println("\\begin{figure}");
                TexSerializer.this.println("\\centering");
                if (size[0] > 400) {
                    TexSerializer.this.println("\\includegraphics[width=0.95\\textwidth]{images/" + ref + "}");
                } else {
                    TexSerializer.this.println("\\includegraphics{images/" + ref + "}");
                }
                TexSerializer.this.println("\\caption{" + caption + "}");
                TexSerializer.this.println("\\label{" + label + "}");
                TexSerializer.this.println("\\end{figure}");
                TexSerializer.this.println();
                if (this.fImageSizes.containsKey(ref)) {
                    size = this.fImageSizes.get(ref);
                } else {
                    size = TexSerializer.this.getImageSize(ref);
                    this.fImageSizes.put(ref, size);
                }
            }

            @Override
            protected void handleReference(String ref, String label, WikiParameters params) {
                int idx1 = ref.indexOf(62);
                if (idx1 > 0) {
                    label = ref.substring(0, idx1);
                    ref = ref.substring(idx1 + 1);
                }
                ref = ref.substring(ref.indexOf(46) + 1);
                TexSerializer.this.print(TexSerializer.this.texClean(label) + "~(\\ref{" + ref + "})");
            }
        };
    }

    @Override
    public void onEscape(String str) {
        this.print(str);
    }

    @Override
    public void onLineBreak() {
        this.println("\\newline");
    }

    @Override
    public void onNewLine() {
        this.println("");
    }

    @Override
    public void onSpace(String str) {
        this.print(str);
    }

    @Override
    public void onSpecialSymbol(String str) {
        if (str.equals("#")) {
            this.print("\\_\\_");
            return;
        }
        if (str.equals("&")) {
            this.print("\\&");
            return;
        }
        if (str.equals("$")) {
            this.print("\\$");
            return;
        }
        if (str.equals("%")) {
            this.print("\\%");
            return;
        }
        if (!str.equals("}") && !str.equals("{")) {
            this.print(str);
        }
    }

    @Override
    public void onWord(String str) {
        str = this.texClean(str);
        if (this.fContext.fTableHeadCell) {
            this.print("{\\bf ");
            this.fContext.fTableHeadCell = false;
        }
        this.print(str);
    }

    public String texClean(String str) {
        str = str.replace("_", "\\_");
        str = str.replace("#", "\\#");
        str = str.replace("$", "\\$");
        return str;
    }

    class WGet {
        final String commandName = WGet.class.getName();
        int count;
        final PrintStream out = System.out;
        boolean output = true;
        boolean verb;

        WGet() {
        }

        public final void fetchURL(String url, OutputStream output) throws IOException {
            URL url1 = new URL(url);
            URLConnection urlConnection = url1.openConnection();
            BufferedOutputStream bos = new BufferedOutputStream(output);
            if (urlConnection instanceof HttpURLConnection) {
                this.readHttpURL((HttpURLConnection)urlConnection, bos);
            } else {
                this.readURL(urlConnection);
            }
        }

        public final void printHeader(URLConnection url) {
            this.verbose(WGet.class.getName() + ": Content-Length   : " + url.getContentLength());
            this.verbose(WGet.class.getName() + ": Content-Type     : " + url.getContentType());
            if (url.getContentEncoding() != null) {
                this.verbose(WGet.class.getName() + ": Content-Encoding : " + url.getContentEncoding());
            }
        }

        public final void readHttpURL(HttpURLConnection url, OutputStream output) throws IOException {
            block6: {
                url.setAllowUserInteraction(true);
                url.connect();
                long before = System.currentTimeMillis();
                DataInputStream in = new DataInputStream(url.getInputStream());
                long after = System.currentTimeMillis();
                before = System.currentTimeMillis();
                try {
                    if (url.getResponseCode() != 200) {
                        this.out.println(this.commandName + ": " + url.getResponseMessage());
                        break block6;
                    }
                    this.printHeader(url);
                    while (true) {
                        output.write(in.readByte());
                    }
                }
                catch (EOFException e) {
                    after = System.currentTimeMillis();
                    int milliSeconds = (int)(after - before);
                    this.verbose(this.commandName + ": Read " + this.count + " bytes from " + url.getURL());
                    this.verbose(this.commandName + ": HTTP/1.0 " + url.getResponseCode() + " " + url.getResponseMessage());
                    url.disconnect();
                    if (url.usingProxy()) {
                        this.verbose(this.commandName + ": This URL uses a proxy");
                    }
                }
                catch (IOException e) {
                    this.out.println(e + ": " + e.getMessage());
                    this.verbose(this.commandName + ": I/O Error : Read " + this.count + " bytes from " + url.getURL());
                    this.out.println(this.commandName + ": I/O Error " + url.getResponseMessage());
                }
            }
            output.flush();
            output.close();
        }

        public final void readURL(URLConnection url) throws IOException {
            DataInputStream in = new DataInputStream(url.getInputStream());
            this.printHeader(url);
            try {
                while (true) {
                    System.out.println((char)in.readUnsignedByte());
                }
            }
            catch (EOFException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public final void verbose(String s) {
            if (this.verb) {
                this.out.println(s);
            }
        }
    }

    private static class DocumentContext {
        boolean fFirstRowCell = false;
        boolean fTableHead = false;
        boolean fTableHeadCell = false;

        private DocumentContext() {
        }
    }
}

