/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());

    public abstract AbstractBox createBox(byte[] var1, byte[] var2, byte[] var3, Box var4);

    public AbstractBox parseBox(IsoBufferWrapper in, ContainerBox parent, Box lastMovieFragmentBox) throws IOException {
        long contentSize;
        long offset = in.position();
        long size = in.readUInt32();
        if (size < 8L && size > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + size + "). Stop parsing!");
            return null;
        }
        if (offset + size > in.size()) {
            LOG.severe("Plausibility check failed: offset (" + offset + ") + size (" + size + ") > file size (" + in.size() + "). Stop parsing!");
            return null;
        }
        byte[] type = in.read(4);
        String prefix = "";
        boolean iWant = false;
        if (iWant) {
            for (ContainerBox t = parent.getParent(); t != null; t = t.getParent()) {
                prefix = IsoFile.bytesToFourCC(t.getType()) + "/" + prefix;
            }
            System.err.println(prefix + IsoFile.bytesToFourCC(type) + "  - offset: " + offset);
        }
        byte[] usertype = null;
        if (size == 1L) {
            size = in.readUInt64();
            contentSize = size - 16L;
        } else if (size == 0L) {
            contentSize = -1L;
            size = 1L;
        } else {
            contentSize = size - 8L;
        }
        if (Arrays.equals(type, IsoFile.fourCCtoBytes("uuid"))) {
            usertype = in.read(16);
            contentSize -= 16L;
        }
        AbstractBox box = this.createBox(type, usertype, parent.getType(), lastMovieFragmentBox);
        box.offset = offset;
        box.setParent(parent);
        LOG.finest("Parsing " + IsoFile.bytesToFourCC(box.getType()));
        box.parse(in, contentSize, this, lastMovieFragmentBox);
        if (in.position() - offset < size && contentSize != -1L) {
            LOG.finer(IsoFile.bytesToFourCC(type) + " has dead bytes");
            long length = size - (in.position() - offset);
            assert (length < Integer.MAX_VALUE) : "Ooops length larger than Integer.MAX_VALUE";
            box.setDeadBytes(in.getSegment(in.position(), length));
            in.skip(length);
        }
        assert (size == box.getSize()) : "Reconstructed Size is not equal to the number of parsed bytes! (" + IsoFile.bytesToFourCC(box.getType()) + ")" + " Actual Box size: " + size + " Calculated size: " + box.getSize() + " at offset: " + offset;
        return box;
    }
}

