/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.pdfviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

public class PDFViewerService {
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerService.class.getName());
    private JodConverterService jodConverter_;
    private ExoCache<Serializable, Object> pdfCache;

    public PDFViewerService(RepositoryService repositoryService, CacheService caService, JodConverterService jodConverter) throws Exception {
        this.jodConverter_ = jodConverter;
        this.pdfCache = caService.getCacheInstance(PDFViewerService.class.getName());
    }

    public ExoCache<Serializable, Object> getCache() {
        return this.pdfCache;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    public Document buildDocumentImage(File input, String name) {
        Document document;
        block8: {
            document = new Document();
            Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
            try {
                document.setInputStream((InputStream)new BufferedInputStream(new FileInputStream(input)), name);
            }
            catch (PDFException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error parsing PDF document " + (Object)((Object)ex)));
                }
            }
            catch (PDFSecurityException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error encryption not supported " + (Object)((Object)ex)));
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Error file not found " + ex));
                }
            }
            catch (IOException ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Error handling PDF document: {} {}", new Object[]{name, ex.toString()});
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        String wsName = currentNode.getSession().getWorkspace().getName();
        String uuid = currentNode.getUUID();
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        bd1.append((CharSequence)bd).append("/jcr:lastModified");
        String path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        String lastModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        File content = null;
        String name = currentNode.getName();
        Node contentNode = currentNode.getNode("jcr:content");
        String lastModified = contentNode.getProperty("jcr:lastModified").getString();
        if (path == null || !(content = new File(path)).exists() || !lastModified.equals(lastModifiedTime)) {
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            BufferedInputStream input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            content = File.createTempFile(name + "_tmp", ".pdf");
            String extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            } else {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(content));
                File in = File.createTempFile(name + "_tmp", null);
                this.read(input, new BufferedOutputStream(new FileOutputStream(in)));
                try {
                    boolean success = this.jodConverter_.convert(in, content, "pdf");
                    if (!success) {
                        content.delete();
                    }
                }
                catch (OfficeException connection) {
                    content.delete();
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Exception when using Office Service");
                    }
                }
                finally {
                    in.delete();
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                }
            }
            if (content.exists() && contentNode.hasProperty("jcr:lastModified")) {
                this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
            }
        }
        return content;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }
}

