/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.deployment.plugins.LinkDeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.quartz.JobExecutionContext;
import org.quartz.impl.JobDetailImpl;

public class WCMCoreUtils {
    private static final Log LOG = ExoLogger.getLogger((String)WCMCoreUtils.class.getName());
    private static String WEBCONTENT_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and jcr:mixinTypes <> 'exo:restoreLocation' order by exo:priority ASC";

    public static <T> T getService(Class<T> clazz) {
        return WCMCoreUtils.getService(clazz, null);
    }

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider;
    }

    public static boolean isAnonim() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return userId == null;
    }

    public static SessionProvider createAnonimProvider() {
        return SessionProvider.createAnonimProvider();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static String getContainerNameFromJobContext(JobExecutionContext context) {
        return ((JobDetailImpl)context.getJobDetail()).getGroup().split(":")[0];
    }

    public static boolean hasPermission(String userId, List<String> permissions, boolean isNeedFullAccess) {
        block11: {
            try {
                OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
                WCMCoreUtils.startRequest(organizationService);
                Collection memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
                String userMembershipTmp = null;
                Membership userMembership = null;
                int count = 0;
                String permissionTmp = "";
                for (String permission : permissions) {
                    if (!permissionTmp.equals(permission)) {
                        count = 0;
                    }
                    for (Object userMembershipObj : memberships) {
                        userMembership = (Membership)userMembershipObj;
                        if (permission.equals(userMembership.getUserName())) {
                            return true;
                        }
                        if ("any".equals(permission)) {
                            if (isNeedFullAccess) {
                                if (++count != 4) continue;
                                return true;
                            }
                            return true;
                        }
                        if (permission.startsWith("*") && permission.contains(userMembership.getGroupId())) {
                            if (isNeedFullAccess) {
                                if (++count != 4) continue;
                                return true;
                            }
                            return true;
                        }
                        userMembershipTmp = userMembership.getMembershipType() + ":" + userMembership.getGroupId();
                        if (!permission.equals(userMembershipTmp)) continue;
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    permissionTmp = permission;
                }
                WCMCoreUtils.endRequest(organizationService);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block11;
                LOG.error((Object)"hasPermission() failed because of ", (Throwable)e);
            }
        }
        return false;
    }

    public static <T> List<T> getAllElementsOfListAccess(ListAccess<T> listAccess) {
        try {
            return Arrays.asList(listAccess.load(0, listAccess.getSize()));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"getAllElementsOfListAccess() failed because of ", (Throwable)e);
            }
            return null;
        }
    }

    public static ManageableRepository getRepository() {
        try {
            RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"getRepository() failed because of ", (Throwable)e);
            }
            return null;
        }
    }

    public static void startRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).startRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static void endRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static String getProjectVersion() throws Exception {
        String filePath = "jar:/conf/projectInfo.properties";
        Properties productInformationProperties = new Properties();
        try {
            ConfigurationManager configManager = WCMCoreUtils.getService(ConfigurationManager.class);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Read products versions from " + filePath));
            }
            InputStream inputStream = configManager.getInputStream(filePath);
            productInformationProperties.load(inputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException("Couldn't parse the file " + filePath, exception);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error occured while reading the file " + filePath, exception);
        }
        if (!productInformationProperties.containsKey("project.current.version")) {
            throw new RuntimeException("Missing product information.");
        }
        return productInformationProperties.getProperty("project.current.version");
    }

    public static String getActiveStylesheet(Node webcontent) throws Exception {
        StringBuffer buffer;
        block3: {
            buffer = new StringBuffer();
            String cssQuery = StringUtils.replaceOnce((String)WEBCONTENT_CSS_QUERY, (String)"{path}", (String)webcontent.getPath());
            NodeLocation webcontentLocation = NodeLocation.getNodeLocationByNode(webcontent);
            ManageableRepository repository = (ManageableRepository)webcontent.getSession().getRepository();
            Session session = null;
            try {
                session = webcontentLocation.getPath().startsWith("/jcr:system") ? WCMCoreUtils.getSystemSessionProvider().getSession(repository.getConfiguration().getSystemWorkspaceName(), repository) : WCMCoreUtils.getSystemSessionProvider().getSession(webcontentLocation.getWorkspace(), repository);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(cssQuery, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator iterator = queryResult.getNodes();
                while (iterator.hasNext()) {
                    Node registeredCSSFile = iterator.nextNode();
                    buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unexpected problem happen when active stylesheet", (Throwable)e);
            }
        }
        return buffer.toString();
    }

    public static String getSiteGlobalActiveStylesheet(Node siteNode) throws Exception {
        StringBuffer buffer;
        block7: {
            buffer = new StringBuffer();
            try {
                ArrayList<Node> cssNodeList = new ArrayList<Node>();
                NodeIterator iterator = siteNode.getNodes();
                while (iterator.hasNext()) {
                    Node cssFolder = iterator.nextNode();
                    if (!cssFolder.isNodeType("exo:cssFolder")) continue;
                    NodeIterator iter = cssFolder.getNodes();
                    while (iter.hasNext()) {
                        Node registeredCSSFile = iter.nextNode();
                        if (!registeredCSSFile.isNodeType("exo:cssFile") || !registeredCSSFile.getProperty("exo:active").getBoolean()) continue;
                        cssNodeList.add(registeredCSSFile);
                    }
                }
                Collections.sort(cssNodeList, new FileCSSComparatorByPriority());
                for (Node registeredCSSFile : cssNodeList) {
                    try {
                        buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("Unexpected problem happens when get css " + registeredCSSFile.getPath() + " for site '" + siteNode.getName() + "':"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"Unexpected problem happen when active stylesheet", (Throwable)e);
            }
        }
        return buffer.toString();
    }

    public static String getSiteGlobalActiveJs(Node siteNode) throws Exception {
        StringBuffer buffer;
        block7: {
            buffer = new StringBuffer();
            try {
                ArrayList<Node> jsNodeList = new ArrayList<Node>();
                NodeIterator iterator = siteNode.getNodes();
                while (iterator.hasNext()) {
                    Node jsFolder = iterator.nextNode();
                    if (!jsFolder.isNodeType("exo:jsFolder")) continue;
                    NodeIterator iter = jsFolder.getNodes();
                    while (iter.hasNext()) {
                        Node registeredJSFile = iter.nextNode();
                        if (!registeredJSFile.isNodeType("exo:jsFile") || !registeredJSFile.getProperty("exo:active").getBoolean()) continue;
                        jsNodeList.add(registeredJSFile);
                    }
                }
                Collections.sort(jsNodeList, new FileComparatorByPriority());
                for (Node registeredJSFile : jsNodeList) {
                    try {
                        buffer.append(registeredJSFile.getNode("jcr:content").getProperty("jcr:data").getString());
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("Unexpected problem happens when get javascript " + registeredJSFile.getPath() + " for site '" + siteNode.getName() + "':"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"Unexpected problem happen when active javascript", (Throwable)e);
            }
        }
        return buffer.toString();
    }

    public static Hashtable<String, String> getMetadataTemplates(Node node) throws Exception {
        NodeType[] nodeTypes;
        MetadataService metadataService = WCMCoreUtils.getService(MetadataService.class);
        Hashtable<String, String> templates = new Hashtable<String, String>();
        List<String> metaDataList = metadataService.getMetadataList();
        for (NodeType nt : nodeTypes = node.getMixinNodeTypes()) {
            if (!metaDataList.contains(nt.getName())) continue;
            templates.put(nt.getName(), metadataService.getMetadataPath(nt.getName(), false));
        }
        Item primaryItem = null;
        try {
            primaryItem = node.getPrimaryItem();
        }
        catch (ItemNotFoundException e) {
            primaryItem = null;
        }
        if (primaryItem != null && primaryItem.isNode()) {
            NodeType[] primaryTypes;
            Node primaryNode = (Node)node.getPrimaryItem();
            for (NodeType nt : primaryTypes = primaryNode.getMixinNodeTypes()) {
                if (!metaDataList.contains(nt.getName())) continue;
                templates.put(nt.getName(), metadataService.getMetadataPath(nt.getName(), false));
            }
        }
        return templates;
    }

    public static String getRestContextName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return portalContainerConfig.getRestContextName(containerInfo.getContainerName());
    }

    public static void deployLinkToPortal(InitParams initParams, RepositoryService repositoryService, LinkManager linkManager, SessionProvider sessionProvider, String portalName) throws Exception {
        Iterator iterator = initParams.getObjectParamIterator();
        LinkDeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (LinkDeploymentDescriptor)objectParameter.getObject();
                String sourcePath = deploymentDescriptor.getSourcePath();
                String targetPath = deploymentDescriptor.getTargetPath();
                if (portalName != null && portalName.length() > 0) {
                    sourcePath = StringUtils.replace((String)sourcePath, (String)"{portalName}", (String)portalName);
                    targetPath = StringUtils.replace((String)targetPath, (String)"{portalName}", (String)portalName);
                }
                String[] src = sourcePath.split(":");
                String[] tgt = targetPath.split(":");
                if (src.length == 3 && tgt.length == 3) {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    Session session = sessionProvider.getSession(src[1], repository);
                    ManageableRepository repository2 = repositoryService.getCurrentRepository();
                    Session session2 = sessionProvider.getSession(tgt[1], repository2);
                    Node nodeSrc = session.getRootNode().getNode(src[2].substring(1));
                    Node nodeTgt = session2.getRootNode().getNode(tgt[2].substring(1));
                    linkManager.createLink(nodeTgt, "exo:taxonomyLink", nodeSrc);
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
                    String containerName = containerInfo.getContainerName();
                    ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class, containerName);
                    CmsService cmsService = WCMCoreUtils.getService(CmsService.class, containerName);
                    listenerService.broadcast("WCMPublicationService.event.updateState", (Object)cmsService, (Object)nodeSrc);
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(sourcePath + " has a link into " + targetPath));
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("create link from " + deploymentDescriptor.getSourcePath() + " to " + deploymentDescriptor.getTargetPath() + " is FAILURE at " + new Date().toString() + "\n"), (Throwable)ex);
            }
            throw ex;
        }
    }

    public static String generateImageURI(Node file, String propertyName) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fileLocation = NodeLocation.getNodeLocationByNode(file);
        String repository = fileLocation.getRepository();
        String workspaceName = fileLocation.getWorkspace();
        String nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (propertyName == null) {
            if (!file.isNodeType("nt:file")) {
                return null;
            }
            InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
            if (stream.available() == 0) {
                return null;
            }
            stream.close();
            builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=file");
            return builder.toString();
        }
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=").append(propertyName);
        return builder.toString();
    }

    public static String getPortalName() {
        PortalContainerInfo containerInfo = WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public static String getRemoteUser() {
        try {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private static class FileCSSComparatorByPriority
    implements Comparator<Node> {
        private FileCSSComparatorByPriority() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (!o1.hasProperty("exo:priority")) {
                    return -1;
                }
                if (!o2.hasProperty("exo:priority")) {
                    return 1;
                }
                return (int)(o1.getProperty("exo:priority").getLong() - o2.getProperty("exo:priority").getLong());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    private static class FileComparatorByPriority
    implements Comparator<Node> {
        private FileComparatorByPriority() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (!o1.hasProperty("exo:priority")) {
                    return 1;
                }
                if (!o2.hasProperty("exo:priority")) {
                    return -1;
                }
                return (int)(o2.getProperty("exo:priority").getLong() - o1.getProperty("exo:priority").getLong());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

