/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.presentation.removecomment;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.action.UIPresentationEventListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;

@ComponentConfig(events={@EventConfig(listeners={RemoveCommentActionListener.class}, confirm="RemoveCommentComponent.msg.confirm-deletecomment")})
public class RemoveCommentComponent
extends AbstractActionComponent {
    private static final Log LOG = ExoLogger.getLogger((String)RemoveCommentComponent.class.getName());

    protected String loadConfirmMesssage(Event event, WebuiRequestContext context, String beanId) {
        String confirmKey = event.getConfirm();
        if (confirmKey.length() < 1) {
            return confirmKey;
        }
        try {
            String confirm = Utils.getResourceBundle("locale.portlet.i18n.WebUIDms", confirmKey, ((Object)((Object)this)).getClass().getClassLoader());
            return confirm.replaceAll("\\{0\\}", beanId);
        }
        catch (Exception e) {
            return confirmKey;
        }
    }

    public static void doDelete(Map<String, Object> variables) throws Exception {
        AbstractActionComponent uicomponent = (AbstractActionComponent)((Object)variables.get("uicomponent"));
        UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
        NodeFinder nodefinder = (NodeFinder)uicomponent.getApplicationComponent(NodeFinder.class);
        String wsname = String.valueOf(variables.get("workspaceName"));
        String nodepath = String.valueOf(variables.get("objectId"));
        WebuiRequestContext requestcontext = (WebuiRequestContext)variables.get("requestcontext");
        try {
            Node commentNode = (Node)nodefinder.getItem(wsname, Text.escapeIllegalJcrChars((String)nodepath));
            CommentsService commentService = (CommentsService)uicomponent.getApplicationComponent(CommentsService.class);
            commentService.deleteComment(commentNode);
            uicomponent.updateAjax(requestcontext);
        }
        catch (VersionException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Version exception");
            }
            Object[] args = new Object[]{nodepath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-delete-version", args, 1));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            }
            JCRExceptionManager.process(uiApp, e);
        }
    }

    public static class RemoveCommentActionListener
    extends UIPresentationEventListener<RemoveCommentComponent> {
        @Override
        protected void executeAction(Map<String, Object> variables) throws Exception {
            RemoveCommentComponent.doDelete(variables);
        }
    }
}

