/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.resource.Codec;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

class CompositeSkin
implements Skin {
    private final SkinService service;
    private final String id;
    private final String urlPrefix;

    CompositeSkin(SkinService service, Collection<SkinConfig> skins) {
        TreeMap<String, SkinConfig> urlSkins = new TreeMap<String, SkinConfig>();
        for (SkinConfig skin : skins) {
            urlSkins.put(skin.getCSSPath(), skin);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(service.portalContainerName).append("/resource");
        StringBuilder id = new StringBuilder();
        try {
            for (SkinConfig cfg : urlSkins.values()) {
                StringBuilder encodedName = new StringBuilder();
                Codec.encode(encodedName, cfg.getName());
                StringBuilder encodedModule = new StringBuilder();
                Codec.encode(encodedModule, cfg.getModule());
                id.append((CharSequence)encodedName).append((CharSequence)encodedModule);
                builder.append("/").append((CharSequence)encodedName).append("/").append((CharSequence)encodedModule);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.service = service;
        this.id = id.toString();
        this.urlPrefix = builder.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SkinURL createURL(final ControllerContext context) {
        if (context == null) {
            throw new NullPointerException("No controller context provided");
        }
        return new SkinURL(){
            Orientation orientation;
            boolean compress = !PropertyManager.isDevelopping();

            @Override
            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }

            @Override
            public String toString() {
                try {
                    String resource = CompositeSkin.this.urlPrefix + "/" + (PropertyManager.isDevelopping() ? "style" : ((CompositeSkin)CompositeSkin.this).service.id);
                    HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
                    params.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
                    params.put(ResourceRequestHandler.ORIENTATION_QN, this.orientation == Orientation.RT ? "rt" : "lt");
                    params.put(ResourceRequestHandler.COMPRESS_QN, this.compress ? "min" : "");
                    params.put(WebAppController.HANDLER_PARAM, "skin");
                    params.put(ResourceRequestHandler.RESOURCE_QN, resource);
                    StringBuilder url = new StringBuilder();
                    context.renderURL(params, new URIWriter((Appendable)url, MimeType.PLAIN));
                    return url.toString();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }
}

