/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.util.List;
import java.util.Map;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.ActivityDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityParameters;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.NamedEntity;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;

@PrimaryType(name="soc:activity", orderable=true)
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ActivityEntity
implements NamedEntity {
    public static final PropertyLiteralExpression<String> identity = new PropertyLiteralExpression<String>(String.class, "soc:identity");
    public static final PropertyLiteralExpression<String> poster = new PropertyLiteralExpression<String>(String.class, "soc:posterIdentity");
    public static final PropertyLiteralExpression<String> title = new PropertyLiteralExpression<String>(String.class, "soc:title");
    public static final PropertyLiteralExpression<String> likes = new PropertyLiteralExpression<String>(String.class, "soc:likes");
    public static final PropertyLiteralExpression<Boolean> isComment = new PropertyLiteralExpression<Boolean>(Boolean.class, "soc:isComment");
    public static final PropertyLiteralExpression<Long> postedTime = new PropertyLiteralExpression<Long>(Long.class, "soc:postedTime");
    public static final PropertyLiteralExpression<Long> lastUpdated = new PropertyLiteralExpression<Long>(Long.class, "soc:lastUpdated");
    public static final PropertyLiteralExpression<String> mentioners = new PropertyLiteralExpression<String>(String.class, "soc:mentioners");
    public static final PropertyLiteralExpression<String> commenters = new PropertyLiteralExpression<String>(String.class, "soc:commenters");

    @Id
    public abstract String getId();

    @Override
    @Name
    public abstract String getName();

    @ManyToOne
    public abstract ActivityEntity getParentActivity();

    @Owner
    @OneToMany
    public abstract List<ActivityEntity> getComments();

    @ManyToOne
    public abstract ActivityDayEntity getDay();

    @MappedBy(value="soc:identity")
    @ManyToOne(type=RelationshipType.REFERENCE)
    public abstract IdentityEntity getIdentity();

    public abstract void setIdentity(IdentityEntity var1);

    @MappedBy(value="soc:posterIdentity")
    @ManyToOne(type=RelationshipType.REFERENCE)
    public abstract IdentityEntity getPosterIdentity();

    public abstract void setPosterIdentity(IdentityEntity var1);

    @Property(name="soc:title")
    public abstract String getTitle();

    public abstract void setTitle(String var1);

    @Property(name="soc:titleId")
    public abstract String getTitleId();

    public abstract void setTitleId(String var1);

    @Property(name="soc:appId")
    public abstract String getAppId();

    public abstract void setAppId(String var1);

    @Property(name="soc:body")
    public abstract String getBody();

    public abstract void setBody(String var1);

    @Property(name="soc:bodyId")
    public abstract String getBodyId();

    public abstract void setBodyId(String var1);

    @Property(name="soc:type")
    public abstract String getType();

    public abstract void setType(String var1);

    @Property(name="soc:externalId")
    public abstract String getExternalId();

    public abstract void setExternalId(String var1);

    @Property(name="soc:url")
    public abstract String getUrl();

    public abstract void setUrl(String var1);

    @Property(name="soc:priority")
    public abstract Float getPriority();

    public abstract void setPriority(Float var1);

    @Property(name="soc:likes")
    public abstract String[] getLikes();

    public abstract void setLikes(String[] var1);

    @Property(name="soc:isComment")
    @DefaultValue(value={"false"})
    public abstract Boolean isComment();

    public abstract void setComment(Boolean var1);

    @Property(name="soc:postedTime")
    public abstract Long getPostedTime();

    public abstract void setPostedTime(Long var1);

    @Property(name="soc:lastUpdated")
    public abstract Long getLastUpdated();

    public abstract void setLastUpdated(Long var1);

    @Property(name="soc:mentioners")
    public abstract String[] getMentioners();

    public abstract void setMentioners(String[] var1);

    @Property(name="soc:commenters")
    public abstract String[] getCommenters();

    public abstract void setCommenters(String[] var1);

    @MappedBy(value="soc:params")
    @OneToOne
    @Owner
    public abstract ActivityParameters getParams();

    public abstract void setParams(ActivityParameters var1);

    @Path
    public abstract String getPath();

    @Create
    public abstract ActivityEntity createComment(String var1);

    @Create
    public abstract ActivityParameters createParams();

    public void putParams(Map<String, String> parameters) {
        ActivityParameters params = this.getParams();
        if (params == null) {
            params = this.createParams();
            this.setParams(params);
        }
        Map<String, String> chromatticMap = params.getParams();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getKey().startsWith("jcr:")) continue;
            chromatticMap.put(entry.getKey(), entry.getValue());
        }
    }
}

