/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIEditingTagList;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITagForm;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITagExplorer;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, template="system:/groovy/portal/webui/container/UIContainer.gtmpl", events={@EventConfig(listeners={EditTagActionListener.class}), @EventConfig(listeners={RemoveTagActionListener.class}, confirm="UIEditingTagsForm.msg.confirm-remove")})
public class UIEditingTagsForm
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIEditingTagsForm.class.getName());
    private static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private static final String USER_FOLKSONOMY_ALIAS = "userPrivateFolksonomy";

    public void activate() {
        block2: {
            try {
                this.addChild(UIEditingTagList.class, null, null);
                ((UIEditingTagList)this.getChild(UIEditingTagList.class)).updateGrid();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void deActivate() {
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ((UIEditingTagList)this.getChild(UIEditingTagList.class)).updateGrid();
        super.processRender(context);
    }

    public void initTaggingFormPopup(Node selectedTag) throws Exception {
        this.removeChildById("TagPopup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "TagPopup");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 200);
        UITagForm uiForm = (UITagForm)this.createUIComponent(UITagForm.class, null, null);
        uiForm.setTag(selectedTag);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public Node getSelectedTag(String tagName) throws Exception {
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String workspace = uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName();
        String userName = uiExplorer.getSession().getUserID();
        int scope = uiExplorer.getTagScope();
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
        List tagList = scope == 0 ? newFolksonomyService.getAllPublicTags(publicTagNodePath, workspace) : newFolksonomyService.getAllPrivateTags(userName);
        for (Node tag : tagList) {
            if (!tag.getName().equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    public static class RemoveTagActionListener
    extends EventListener<UIEditingTagsForm> {
        public void execute(Event<UIEditingTagsForm> event) throws Exception {
            UIEditingTagsForm uiEdit = (UIEditingTagsForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiEdit.getAncestorOfType(UIJCRExplorer.class);
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            this.removeTagFromNode(uiExplorer.getSession().getUserID(), uiExplorer.getTagScope(), selectedName, uiEdit);
            ((UIEditingTagList)uiEdit.getChild(UIEditingTagList.class)).updateGrid();
            uiExplorer.setTagPath(uiExplorer.getCurrentPath());
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiEdit);
        }

        public void removeTagFromNode(String userID, int scope, String tagName, UIEditingTagsForm uiForm) throws Exception {
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String workspace = WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName();
            String tagPath = "";
            if (0 == scope) {
                tagPath = newFolksonomyService.getDataDistributionType().getDataNode((Node)WCMCoreUtils.getUserSessionProvider().getSession(workspace, WCMCoreUtils.getRepository()).getItem(nodeHierarchyCreator.getJcrPath(UIEditingTagsForm.PUBLIC_TAG_NODE_PATH)), tagName).getPath();
                newFolksonomyService.removeTag(tagPath, workspace);
            } else if (1 == scope) {
                Node userFolksonomyNode = this.getUserFolksonomyFolder(userID, uiForm);
                tagPath = newFolksonomyService.getDataDistributionType().getDataNode(userFolksonomyNode, tagName).getPath();
                newFolksonomyService.removeTag(tagPath, workspace);
            }
            ((UITagExplorer)((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).findFirstComponentOfType(UITagExplorer.class)).updateTagList();
        }

        private Node getUserFolksonomyFolder(String userName, UIEditingTagsForm uiForm) throws Exception {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            Node userNode = nodeHierarchyCreator.getUserNode(WCMCoreUtils.getUserSessionProvider(), userName);
            String folksonomyPath = nodeHierarchyCreator.getJcrPath(UIEditingTagsForm.USER_FOLKSONOMY_ALIAS);
            return userNode.getNode(folksonomyPath);
        }
    }

    public static class EditTagActionListener
    extends EventListener<UIEditingTagsForm> {
        public void execute(Event<UIEditingTagsForm> event) throws Exception {
            UIEditingTagsForm uiEditingTagsForm = (UIEditingTagsForm)((Object)event.getSource());
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTag = uiEditingTagsForm.getSelectedTag(selectedName);
            uiEditingTagsForm.initTaggingFormPopup(selectedTag);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiEditingTagsForm.getAncestorOfType(UIJCRExplorer.class);
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiEditingTagsForm);
        }
    }
}

