/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.rendering.syntax.Syntax;

public class PageRenderingCacheServiceImpl
implements PageRenderingCacheService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    private static final Log LOG = ExoLogger.getLogger(PageRenderingCacheService.class);
    private RenderingService renderingService;
    private WikiService wikiService;
    private ExoCache<MarkupKey, MarkupData> renderingCache;
    private Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();

    public PageRenderingCacheServiceImpl(RenderingService renderingService, WikiService wikiService, CacheService cacheService) {
        this.renderingService = renderingService;
        this.wikiService = wikiService;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
    }

    @Override
    public String getRenderedContent(WikiPageParams param, String targetSyntax) {
        String renderedContent = "";
        try {
            PageImpl page = (PageImpl)this.wikiService.getPageById(param.getType(), param.getOwner(), param.getPageId());
            boolean supportSectionEdit = page.hasPermission(PermissionType.EDITPAGE);
            String markup = page.getContent().getText();
            MarkupKey key = new MarkupKey(new WikiPageParams(param.getType(), param.getOwner(), param.getPageId()), markup, page.getSyntax(), targetSyntax, supportSectionEdit);
            MarkupData cachedData = (MarkupData)this.renderingCache.get((Serializable)key);
            if (cachedData != null) {
                return cachedData.build();
            }
            renderedContent = this.renderingService.render(markup, page.getSyntax(), targetSyntax, supportSectionEdit);
            this.renderingCache.put((Serializable)key, (Object)new MarkupData(renderedContent));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get rendered content of page [%s:%s:%s] in syntax %s", param.getType(), param.getOwner(), param.getPageId(), targetSyntax), (Throwable)e);
        }
        return renderedContent;
    }

    @Override
    public final ExoCache<MarkupKey, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    @Override
    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public void addPageLink(WikiPageParams param, WikiPageParams entity) {
        List<WikiPageParams> linkParams = this.pageLinksMap.get(entity);
        if (linkParams == null) {
            linkParams = new ArrayList<WikiPageParams>();
            this.pageLinksMap.put(entity, linkParams);
        }
        linkParams.add(param);
    }

    @Override
    public void invalidateCache(WikiPageParams param) {
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(param);
        if (linkedPages != null && linkedPages.size() != 0) {
            for (WikiPageParams wikiPageParams : linkedPages) {
                try {
                    Page page = this.wikiService.getPageById(wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageId());
                    MarkupKey key = new MarkupKey(wikiPageParams, page.getContent().getText(), page.getSyntax(), Syntax.XHTML_1_0.toIdString(), false);
                    this.getRenderingCache().remove((Serializable)key);
                    key.setSupportSectionEdit(true);
                    this.getRenderingCache().remove((Serializable)key);
                }
                catch (Exception e) {
                    LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageId()));
                }
            }
        }
    }
}

