/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;

public class UserByGroupJCRUserListAccess
extends JCRUserListAccess {
    private final ExtendedNode refUsers;

    public UserByGroupJCRUserListAccess(JCROrganizationServiceImpl service, String groupId) throws RepositoryException {
        super(service);
        this.refUsers = this.getRefUsersNode(groupId);
    }

    protected int getSize(Session session) throws Exception {
        return this.refUsers == null ? 0 : (int)this.refUsers.getNodesCount();
    }

    protected Object readObject(Node node) throws Exception {
        Node userNode = this.utils.getUserNode(node.getSession(), node.getName());
        return this.uHandler.readUser(userNode);
    }

    protected NodeIterator createIterator(Session session) throws RepositoryException {
        return this.refUsers == null ? new EmptyNodeIterator() : this.refUsers.getNodesLazily(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedNode getRefUsersNode(String groupId) throws PathNotFoundException, RepositoryException {
        Session session = this.service.getStorageSession();
        try {
            Node groupNode = this.utils.getGroupNode(this.service.getStorageSession(), groupId);
            ExtendedNode extendedNode = (ExtendedNode)groupNode.getNode("jos:memberships");
            return extendedNode;
        }
        catch (PathNotFoundException e) {
            ExtendedNode extendedNode = null;
            return extendedNode;
        }
        finally {
            session.logout();
        }
    }

    private class EmptyNodeIterator
    implements NodeIterator {
        private EmptyNodeIterator() {
        }

        public void skip(long skipNum) {
        }

        public long getSize() {
            return 0L;
        }

        public long getPosition() {
            return 0L;
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Iteration has no more elements");
        }

        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported");
        }

        public Node nextNode() {
            throw new NoSuchElementException("Iteration has no more elements");
        }
    }
}

