/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.CategoryTree;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQEventQuery;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.InitialDataPlugin;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.QuestionPageList;
import org.exoplatform.faq.service.TemplatePlugin;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.faq.service.impl.FAQServiceManaged;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.faq.service.impl.MultiLanguages;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.NotifyInfo;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@ManagedBy(value=FAQServiceManaged.class)
public class FAQServiceImpl
implements FAQService,
Startable {
    public static final int CATEGORY = 1;
    public static final int QUESTION = 2;
    public static final int SEND_EMAIL = 1;
    private JCRDataStorage jcrData_;
    private TemplatePlugin template_;
    private ConfigurationManager configManager_;
    private Collection<InitialDataPlugin> initDataPlugins;
    private KSDataLocation locator;
    FAQServiceManaged managed;
    private static Log log = ExoLogger.getLogger(FAQServiceImpl.class);
    protected List<AnswerEventListener> listeners_ = new ArrayList<AnswerEventListener>(3);

    public FAQServiceImpl(InitParams params, KSDataLocation locator, ConfigurationManager configManager) throws Exception {
        this.configManager_ = configManager;
        this.initDataPlugins = new ArrayList<InitialDataPlugin>();
        this.locator = locator;
        this.jcrData_ = new JCRDataStorage(locator);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.jcrData_.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.jcrData_.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(InitialDataPlugin plugin) throws Exception {
        this.initDataPlugins.add(plugin);
    }

    public void addTemplatePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof TemplatePlugin) {
            this.template_ = (TemplatePlugin)plugin;
        }
    }

    public void start() {
        log.info((Object)"initializing FAQ default data...");
        try {
            this.jcrData_.initRootCategory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing the root category", e);
        }
        for (InitialDataPlugin plugin : this.initDataPlugins) {
            try {
                if (!plugin.importData(this, this.configManager_)) continue;
                log.info((Object)("imported plugin " + (Object)((Object)plugin)));
            }
            catch (Exception e) {
                log.error((Object)("Error while initializing Data plugin " + plugin.getName()), (Throwable)e);
            }
        }
        try {
            log.info((Object)"initializing FAQ template...");
            this.initViewerTemplate();
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing FAQ template", (Throwable)e);
        }
        try {
            log.info((Object)"initializing Question Node listeners...");
            this.jcrData_.reInitQuestionNodeListeners();
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing Question Node listeners", (Throwable)e);
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewerTemplate() throws Exception {
        if (this.template_ == null) {
            log.warn((Object)"No default template was configured for FAQ.");
            return;
        }
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            if (!this.locator.getSessionManager().getSession(provider).getRootNode().hasNode(this.locator.getFaqTemplatesLocation() + "/" + Utils.UI_FAQ_VIEWER)) {
                InputStream in = this.configManager_.getInputStream(this.template_.getPath());
                byte[] data = new byte[in.available()];
                in.read(data);
                this.saveTemplate(new String(data));
            }
            this.configManager_ = null;
            this.template_ = null;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public List<String> getAllFAQAdmin() throws Exception {
        return this.jcrData_.getAllFAQAdmin();
    }

    public List<Category> getAllCategories(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllCategories();
    }

    @Override
    public List<Category> getAllCategories() throws Exception {
        return this.jcrData_.getAllCategories();
    }

    public QuestionPageList getAllQuestions(SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAllQuestions();
    }

    @Override
    public QuestionPageList getAllQuestions() throws Exception {
        return this.jcrData_.getAllQuestions();
    }

    public QuestionPageList getQuestionsNotYetAnswer(SessionProvider sProvider, String categoryId, FAQSetting setting) throws Exception {
        sProvider.close();
        return this.getQuestionsNotYetAnswer(categoryId, FAQSetting.DISPLAY_APPROVED.equals(setting.getDisplayMode()));
    }

    @Override
    public QuestionPageList getQuestionsNotYetAnswer(String categoryId, boolean isApproved) throws Exception {
        return this.jcrData_.getQuestionsNotYetAnswer(categoryId, isApproved);
    }

    public long[] getCategoryInfo(String categoryId, SessionProvider sProvider, FAQSetting setting) throws Exception {
        sProvider.close();
        return this.getCategoryInfo(categoryId, setting);
    }

    @Override
    public long[] getCategoryInfo(String categoryId, FAQSetting setting) throws Exception {
        return this.jcrData_.getCategoryInfo(categoryId, setting);
    }

    public Category getCategoryById(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryById(categoryId);
    }

    @Override
    public Category getCategoryById(String categoryId) throws Exception {
        return this.jcrData_.getCategoryById(categoryId);
    }

    public Question getQuestionById(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionById(questionId);
    }

    @Override
    public Comment[] getComments(String questionId) throws Exception {
        return this.jcrData_.getComments(questionId);
    }

    @Override
    public Question getQuestionById(String questionId) throws Exception {
        return this.jcrData_.getQuestionById(questionId);
    }

    public QuestionPageList getQuestionsByCatetory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getQuestionsByCatetory(categoryId, faqSetting);
    }

    public QuestionPageList getAllQuestionsByCatetory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getAllQuestionsByCatetory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getAllQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getAllQuestionsByCatetory(categoryId, faqSetting);
    }

    public QuestionPageList getQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    @Override
    public QuestionPageList getQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        return this.jcrData_.getQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    public String getCategoryPathOfQuestion(String questionPath, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryPathOfQuestion(questionPath);
    }

    @Override
    public String getCategoryPathOfQuestion(String questionPath) throws Exception {
        return this.jcrData_.getCategoryPathOfQuestion(questionPath);
    }

    public List<QuestionLanguage> getQuestionLanguages(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getQuestionLanguages(questionId);
    }

    @Override
    public List<QuestionLanguage> getQuestionLanguages(String questionId) {
        return this.jcrData_.getQuestionLanguages(questionId);
    }

    public List<Category> getSubCategories(String categoryId, SessionProvider sProvider, FAQSetting faqSetting, boolean isGetAll, List<String> userView) throws Exception {
        sProvider.close();
        return this.getSubCategories(categoryId, faqSetting, isGetAll, userView);
    }

    @Override
    public List<Category> getSubCategories(String categoryId, FAQSetting faqSetting, boolean isGetAll, List<String> userView) throws Exception {
        return this.jcrData_.getSubCategories(categoryId, faqSetting, isGetAll, userView);
    }

    public void moveQuestions(List<String> questions, String destCategoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.moveQuestions(questions, destCategoryId, "", new FAQSetting());
    }

    @Override
    public void moveQuestions(List<String> questions, String destCategoryId, String questionLink, FAQSetting faqSetting) throws Exception {
        this.jcrData_.moveQuestions(questions, destCategoryId, questionLink, faqSetting);
    }

    public void removeCategory(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.removeCategory(categoryId);
    }

    @Override
    public void removeCategory(String categoryId) throws Exception {
        this.jcrData_.removeCategory(categoryId);
    }

    public void removeQuestion(String questionId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.removeQuestion(questionId);
    }

    @Override
    public void removeQuestion(String questionId) throws Exception {
        String questionActivityId = this.getActivityIdForQuestion(questionId);
        for (AnswerEventListener ae : this.listeners_) {
            ae.removeQuestion(questionActivityId);
        }
        this.jcrData_.removeQuestion(questionId);
    }

    public void saveCategory(String parentId, Category cat, boolean isAddNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveCategory(parentId, cat, isAddNew);
    }

    @Override
    public void saveCategory(String parentId, Category cat, boolean isAddNew) {
        this.jcrData_.saveCategory(parentId, cat, isAddNew);
    }

    @Override
    public CategoryTree buildCategoryTree(String categoryId) throws Exception {
        return this.jcrData_.buildCategoryTree(categoryId);
    }

    public void changeStatusCategoryView(List<String> listCateIds, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.changeStatusCategoryView(listCateIds);
    }

    @Override
    public void changeStatusCategoryView(List<String> listCateIds) throws Exception {
        this.jcrData_.changeStatusCategoryView(listCateIds);
    }

    public Node saveQuestion(Question question, boolean isAddNew, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.saveQuestion(question, isAddNew, faqSetting);
    }

    @Override
    public Node saveQuestion(Question question, boolean isAddNew, FAQSetting faqSetting) throws Exception {
        Question oldQuestion = null;
        if (!isAddNew) {
            oldQuestion = this.getQuestionById(question.getId());
            oldQuestion.setEditedQuestionName(question.getQuestion());
            oldQuestion.setEditedQuestionDetail(question.getDetail());
            oldQuestion.setEditedQuestionAttachment(question.getAttachMent().size());
            oldQuestion.setEditedQuestionActivated(question.isActivated());
            List<QuestionLanguage> questionLanguages = this.getQuestionLanguages(oldQuestion.getPath());
            oldQuestion.setMultiLanguages(questionLanguages.toArray(new QuestionLanguage[questionLanguages.size()]));
            oldQuestion.setEditedQuestionLanguage(question.getMultiLanguages().length + 1);
            question.setPcs(oldQuestion.getPcs());
        }
        Node questionNode = this.jcrData_.saveQuestion(question, isAddNew, faqSetting);
        SessionProvider provider = CommonUtils.createSystemProvider();
        questionNode = (Node)this.locator.getSessionManager().getSession(provider).getItem(questionNode.getPath());
        for (QuestionLanguage lang : question.getMultiLanguages()) {
            if (lang.getState().equals(QuestionLanguage.ADD_NEW) || lang.getState().equals(QuestionLanguage.EDIT)) {
                MultiLanguages.addLanguage(questionNode, lang);
                continue;
            }
            if (!lang.getState().equals(QuestionLanguage.DELETE)) continue;
            MultiLanguages.removeLanguage(questionNode, lang);
        }
        for (AnswerEventListener ae : this.listeners_) {
            ae.saveQuestion(question, isAddNew);
        }
        return questionNode;
    }

    public void saveFAQSetting(FAQSetting faqSetting, String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveFAQSetting(faqSetting, userName);
    }

    @Override
    public void saveFAQSetting(FAQSetting faqSetting, String userName) throws Exception {
        this.jcrData_.saveFAQSetting(faqSetting, userName);
    }

    public void moveCategory(String categoryId, String destCategoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.moveCategory(categoryId, destCategoryId);
    }

    @Override
    public void moveCategory(String categoryId, String destCategoryId) throws Exception {
        this.jcrData_.moveCategory(categoryId, destCategoryId);
    }

    public void addWatch(String id, Watch watch, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.addWatchCategory(id, watch);
    }

    @Override
    public void addWatchCategory(String id, Watch watch) throws Exception {
        this.jcrData_.addWatchCategory(id, watch);
    }

    public void deleteMailInWatch(String categoryId, SessionProvider sProvider, String user) throws Exception {
        sProvider.close();
        this.deleteCategoryWatch(categoryId, user);
    }

    @Override
    public void deleteCategoryWatch(String categoryId, String user) throws Exception {
        this.jcrData_.deleteCategoryWatch(categoryId, user);
    }

    public void UnWatch(String categoryId, SessionProvider sProvider, String userCurrent) throws Exception {
        sProvider.close();
        this.unWatchCategory(categoryId, userCurrent);
    }

    @Override
    public void unWatchCategory(String categoryId, String userCurrent) throws Exception {
        this.jcrData_.unWatchCategory(categoryId, userCurrent);
    }

    public void UnWatchQuestion(String questionID, SessionProvider sProvider, String userCurrent) throws Exception {
        sProvider.close();
        this.unWatchQuestion(questionID, userCurrent);
    }

    @Override
    public void unWatchQuestion(String questionID, String userCurrent) throws Exception {
        this.jcrData_.unWatchQuestion(questionID, userCurrent);
    }

    public List<String> getListCateIdByModerator(String user, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getListCateIdByModerator(user);
    }

    @Override
    public List<String> getListCateIdByModerator(String user) throws Exception {
        return this.jcrData_.getListCateIdByModerator(user);
    }

    @Override
    public List<ObjectSearchResult> getSearchResults(FAQEventQuery eventQuery) throws Exception {
        return this.jcrData_.getSearchResults(eventQuery);
    }

    public List<String> getCategoryPath(SessionProvider sProvider, String categoryId) throws Exception {
        sProvider.close();
        return this.getCategoryPath(categoryId);
    }

    @Override
    public List<String> getCategoryPath(String categoryId) throws Exception {
        return this.jcrData_.getCategoryPath(categoryId);
    }

    @Override
    public Iterator<NotifyInfo> getPendingMessages() {
        return this.jcrData_.getPendingMessages();
    }

    @Override
    public void addLanguage(Node questionNode, QuestionLanguage language) throws Exception {
        MultiLanguages.addLanguage(questionNode, language);
    }

    public void getUserSetting(SessionProvider sProvider, String userName, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        this.getUserSetting(userName, faqSetting);
    }

    @Override
    public void getUserSetting(String userName, FAQSetting faqSetting) throws Exception {
        this.jcrData_.getUserSetting(userName, faqSetting);
    }

    @Override
    public NotifyInfo getMessageInfo(String name) throws Exception {
        return this.jcrData_.getMessageInfo(name);
    }

    public boolean isAdminRole(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.isAdminRole(userName);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.jcrData_.isAdminRole(userName);
    }

    public Node getCategoryNodeById(String categoryId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getCategoryNodeById(categoryId);
    }

    @Override
    public Node getCategoryNodeById(String categoryId) throws Exception {
        return this.jcrData_.getCategoryNodeById(categoryId);
    }

    public void addWatchQuestion(String questionId, Watch watch, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.addWatchQuestion(questionId, watch, isNew);
    }

    @Override
    public void addWatchQuestion(String questionId, Watch watch, boolean isNew) throws Exception {
        this.jcrData_.addWatchQuestion(questionId, watch, isNew);
    }

    public QuestionPageList getListQuestionsWatch(FAQSetting faqSetting, String currentUser, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getListQuestionsWatch(faqSetting, currentUser);
    }

    @Override
    public QuestionPageList getListQuestionsWatch(FAQSetting faqSetting, String currentUser) throws Exception {
        return this.jcrData_.getListQuestionsWatch(faqSetting, currentUser);
    }

    public void importData(String categoryId, Session session, InputStream inputStream, boolean isZip, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.importData(categoryId, inputStream, isZip);
    }

    @Override
    public boolean importData(String categoryId, InputStream inputStream, boolean isZip) throws Exception {
        return this.jcrData_.importData(categoryId, inputStream, isZip);
    }

    @Override
    public InputStream exportData(String categoryId, boolean createZipFile) throws Exception {
        return this.jcrData_.exportData(categoryId, createZipFile);
    }

    public void swapCategories(String parentCateId, String cateId1, String cateId2, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.swapCategories(cateId1, cateId2);
    }

    @Override
    public void swapCategories(String cateId1, String cateId2) throws Exception {
        this.jcrData_.swapCategories(cateId1, cateId2);
    }

    public void saveTopicIdDiscussQuestion(String questionId, String pathDiscuss, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveTopicIdDiscussQuestion(questionId, pathDiscuss);
    }

    @Override
    public void saveTopicIdDiscussQuestion(String questionId, String pathDiscuss) throws Exception {
        this.jcrData_.saveTopicIdDiscussQuestion(questionId, pathDiscuss);
    }

    public long getMaxindexCategory(String parentId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getMaxindexCategory(parentId);
    }

    @Override
    public long getMaxindexCategory(String parentId) throws Exception {
        return this.jcrData_.getMaxindexCategory(parentId);
    }

    public void deleteAnswer(String questionId, String answerId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.deleteAnswer(questionId, answerId);
    }

    @Override
    public void deleteAnswer(String questionId, String answerId) throws Exception {
        this.jcrData_.deleteAnswer(questionId, answerId);
    }

    public void deleteComment(String questionId, String commentId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.deleteComment(questionId, commentId);
    }

    @Override
    public void deleteComment(String questionId, String commentId) throws Exception {
        this.jcrData_.deleteComment(questionId, commentId);
    }

    public void saveAnswer(String questionId, Answer answer, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveAnswer(questionId, answer, isNew);
    }

    @Override
    public void saveAnswer(String questionId, Answer answer, boolean isNew) throws Exception {
        this.jcrData_.saveAnswer(questionId, answer, isNew);
        for (AnswerEventListener ae : this.listeners_) {
            ae.saveAnswer(questionId, answer, isNew);
        }
    }

    public void saveComment(String questionId, Comment comment, boolean isNew, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveComment(questionId, comment, isNew);
    }

    @Override
    public void saveComment(String questionId, Comment comment, boolean isNew) throws Exception {
        this.jcrData_.saveComment(questionId, comment, isNew);
    }

    public Comment getCommentById(SessionProvider sProvider, String questionId, String commentId) throws Exception {
        sProvider.close();
        return this.getCommentById(questionId, commentId);
    }

    @Override
    public Comment getCommentById(String questionId, String commentId) throws Exception {
        return this.jcrData_.getCommentById(questionId, commentId);
    }

    public Answer getAnswerById(String questionId, String answerid, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getAnswerById(questionId, answerid);
    }

    @Override
    public Answer getAnswerById(String questionId, String answerid) throws Exception {
        return this.jcrData_.getAnswerById(questionId, answerid);
    }

    public void saveAnswer(String questionId, Answer[] answers, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveAnswer(questionId, answers);
    }

    @Override
    public void saveAnswer(String questionId, Answer[] answers) throws Exception {
        for (Answer answer : answers) {
            Answer oldAnswer = this.getAnswerById(questionId, answer.getId());
            if (oldAnswer == null) continue;
            oldAnswer.setEditedAnswer(answer.getResponses());
            oldAnswer.setEditedAnswerActivated(answer.getActivateAnswers());
            oldAnswer.setEditedAnswerApproved(answer.getApprovedAnswers());
            answer.setPcs(oldAnswer.getPcs());
        }
        this.jcrData_.saveAnswer(questionId, answers);
        for (AnswerEventListener ae : this.listeners_) {
            ae.saveAnswer(questionId, answers, true);
        }
    }

    public JCRPageList getPageListAnswer(SessionProvider sProvider, String questionId, boolean isSortByVote) throws Exception {
        sProvider.close();
        return this.getPageListAnswer(questionId, isSortByVote);
    }

    @Override
    public JCRPageList getPageListAnswer(String questionId, boolean isSortByVote) throws Exception {
        return this.jcrData_.getPageListAnswer(questionId, isSortByVote);
    }

    public JCRPageList getPageListComment(SessionProvider sProvider, String questionId) throws Exception {
        sProvider.close();
        return this.getPageListComment(questionId);
    }

    @Override
    public JCRPageList getPageListComment(String questionId) throws Exception {
        return this.jcrData_.getPageListComment(questionId);
    }

    public QuestionPageList getListCategoriesWatch(String userId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getWatchedCategoryByUser(userId);
    }

    @Override
    public QuestionPageList getWatchedCategoryByUser(String userId) throws Exception {
        return this.jcrData_.getWatchedCategoryByUser(userId);
    }

    public FileAttachment getUserAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.getUserAvatar(userName);
    }

    @Override
    public FileAttachment getUserAvatar(String userName) throws Exception {
        return this.jcrData_.getUserAvatar(userName);
    }

    public void saveUserAvatar(String userId, FileAttachment fileAttachment, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void saveUserAvatar(String userId, FileAttachment fileAttachment) throws Exception {
        this.jcrData_.saveUserAvatar(userId, fileAttachment);
    }

    public void setDefaultAvatar(String userName, SessionProvider sProvider) throws Exception {
        sProvider.close();
        this.setDefaultAvatar(userName);
    }

    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        this.jcrData_.setDefaultAvatar(userName);
    }

    public boolean getWatchByUser(String userId, String cateId, SessionProvider sProvider) throws Exception {
        sProvider.close();
        return this.isUserWatched(userId, cateId);
    }

    @Override
    public boolean isUserWatched(String userId, String cateId) {
        return this.jcrData_.isUserWatched(userId, cateId);
    }

    public QuestionPageList getPendingQuestionsByCategory(String categoryId, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        sProvider.close();
        return this.getPendingQuestionsByCategory(categoryId, faqSetting);
    }

    @Override
    public QuestionPageList getPendingQuestionsByCategory(String categoryId, FAQSetting faqSetting) throws Exception {
        return this.jcrData_.getPendingQuestionsByCategory(categoryId, faqSetting);
    }

    @Override
    public boolean isExisting(String path) throws Exception {
        return this.jcrData_.isExisting(path);
    }

    @Override
    public String getCategoryPathOf(String id) throws Exception {
        return this.jcrData_.getCategoryPathOf(id);
    }

    @Override
    public List<String> getQuestionContents(List<String> paths) throws Exception {
        return this.jcrData_.getQuestionContents(paths);
    }

    @Override
    public Map<String, String> getRelationQuestion(List<String> paths) throws Exception {
        return this.jcrData_.getRelationQuestion(paths);
    }

    @Override
    public Node getQuestionNodeById(String path) throws Exception {
        return this.jcrData_.getQuestionNodeById(path);
    }

    @Override
    public boolean isModerateAnswer(String id) throws Exception {
        return this.jcrData_.isModerateAnswer(id);
    }

    @Override
    public boolean isModerateQuestion(String id) throws Exception {
        return this.jcrData_.isModerateQuestion(id);
    }

    @Override
    public String getParentCategoriesName(String path) throws Exception {
        return this.jcrData_.getParentCategoriesName(path);
    }

    @Override
    public QuestionPageList getListMailInWatch(String categoryId) throws Exception {
        return this.jcrData_.getListMailInWatch(categoryId);
    }

    @Override
    public boolean isCategoryModerator(String categoryId, String user) throws Exception {
        return this.jcrData_.isCategoryModerator(categoryId, user);
    }

    @Override
    public void addLanguage(String questionPath, QuestionLanguage language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.addLanguage(questionNode, language);
        }
        catch (Exception e) {
            log.error((Object)"Fail to add language: ", (Throwable)e);
        }
    }

    @Override
    public void deleteAnswerQuestionLang(String questionPath, String answerId, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Answer answer = this.getAnswerById(questionPath, answerId, language);
            String answerActivityId = this.getActivityIdForAnswer(questionPath, answer);
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.deleteAnswerQuestionLang(questionNode, answerId, language);
            for (AnswerEventListener ae : this.listeners_) {
                ae.removeAnswer(questionPath, answerActivityId);
            }
        }
        catch (Exception e) {
            log.error((Object)("Fail to delete " + answerId + " :"), (Throwable)e);
        }
    }

    @Override
    public void deleteCommentQuestionLang(String questionPath, String commentId, String language, boolean isPromoted) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String commentActivityId = this.getActivityIdForComment(questionPath, commentId, language);
            String questionActivityId = this.getActivityIdForQuestion(questionPath);
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.deleteCommentQuestionLang(questionNode, commentId, language);
            if (!isPromoted) {
                for (AnswerEventListener ae : this.listeners_) {
                    ae.removeComment(questionActivityId, commentActivityId, questionPath);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Fail to delete " + commentId + " comment question"), (Throwable)e);
        }
    }

    @Override
    public QuestionLanguage getQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
        return MultiLanguages.getQuestionLanguageByLanguage(questionNode, language);
    }

    @Override
    public Comment getCommentById(String questionPath, String commentId, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            return MultiLanguages.getCommentById(questionNode, commentId, language);
        }
        catch (Exception e) {
            log.error((Object)"Fail to get comment", (Throwable)e);
            return null;
        }
    }

    @Override
    public Answer getAnswerById(String questionPath, String answerid, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            return MultiLanguages.getAnswerById(questionNode, answerid, language);
        }
        catch (Exception e) {
            log.error((Object)("Fail to get answer: " + e.getMessage()));
            return null;
        }
    }

    @Override
    public void saveAnswer(String questionPath, Answer answer, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Answer oldAnswer = this.getAnswerById(questionPath, answer.getId());
            if (oldAnswer != null) {
                oldAnswer.setEditedAnswerActivated(answer.getActivateAnswers());
                oldAnswer.setEditedAnswerApproved(answer.getApprovedAnswers());
                answer.setPcs(oldAnswer.getPcs());
            }
            if (answer.getChangeEvent().length == 0) {
                answer.setEditedAnswerPromoted(true);
            }
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveAnswer(questionNode, answer, language);
            for (AnswerEventListener ae : this.listeners_) {
                ae.saveAnswer(questionPath, answer, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Fail to save answer:", (Throwable)e);
        }
    }

    @Override
    public void saveAnswer(String questionPath, QuestionLanguage questionLanguage) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveAnswer(questionNode, questionLanguage);
        }
        catch (Exception e) {
            log.error((Object)"Fail to save answer: ", (Throwable)e);
        }
    }

    @Override
    public void saveComment(String questionPath, Comment comment, String language) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.saveComment(questionNode, comment, language);
            for (AnswerEventListener ae : this.listeners_) {
                ae.saveComment(questionPath, comment, language);
            }
        }
        catch (Exception e) {
            log.error((Object)"\nFail to save comment\n ", (Throwable)e);
        }
    }

    @Override
    public void removeLanguage(String questionPath, List<String> listLanguage) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.removeLanguage(questionNode, listLanguage);
        }
        catch (Exception e) {
            log.error((Object)"\nFail to remove language\n", (Throwable)e);
        }
    }

    @Override
    public void voteAnswer(String answerPath, String userName, boolean isUp) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node answerNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(answerPath);
            MultiLanguages.voteAnswer(answerNode, userName, isUp);
        }
        catch (Exception e) {
            log.error((Object)"\nFail to vote answer\n", (Throwable)e);
        }
    }

    @Override
    public void voteQuestion(String questionPath, String userName, int number) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.voteQuestion(questionNode, userName, number);
            for (AnswerEventListener ae : this.listeners_) {
                ae.voteQuestion(questionNode.getName());
            }
        }
        catch (Exception e) {
            log.error((Object)"\nFail to vote question\n", (Throwable)e);
        }
    }

    @Override
    public void unVoteQuestion(String questionPath, String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node questionNode = this.jcrData_.getFAQServiceHome(sProvider).getNode(questionPath);
            MultiLanguages.unVoteQuestion(questionNode, userName);
            for (AnswerEventListener ae : this.listeners_) {
                ae.unVoteQuestion(questionNode.getName());
            }
        }
        catch (Exception e) {
            log.error((Object)"\nFail to unvote question\n", (Throwable)e);
        }
    }

    @Override
    public String[] getModeratorsOf(String path) throws Exception {
        return this.jcrData_.getModeratorsOf(path);
    }

    @Override
    public boolean isViewAuthorInfo(String id) {
        return this.jcrData_.isViewAuthorInfo(id);
    }

    @Override
    public long existingCategories() throws Exception {
        return this.jcrData_.existingCategories();
    }

    @Override
    public String getCategoryNameOf(String categoryPath) throws Exception {
        return this.jcrData_.getCategoryNameOf(categoryPath);
    }

    @Override
    public List<Question> getQuickQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        return this.jcrData_.getQuickQuestionsByListCatetory(listCategoryId, isNotYetAnswer);
    }

    @Override
    public List<Cate> listingCategoryTree() throws Exception {
        return this.jcrData_.listingCategoryTree();
    }

    @Override
    public List<Watch> getWatchByCategory(String categoryId) throws Exception {
        return this.jcrData_.getWatchByCategory(categoryId);
    }

    @Override
    public boolean hasWatch(String categoryPath) {
        return this.jcrData_.hasWatch(categoryPath);
    }

    @Override
    public CategoryInfo getCategoryInfo(String categoryPath, List<String> categoryIdScoped) throws Exception {
        return this.jcrData_.getCategoryInfo(categoryPath, categoryIdScoped);
    }

    @Override
    public byte[] getTemplate() throws Exception {
        return this.jcrData_.getTemplate();
    }

    @Override
    public void saveTemplate(String str) throws Exception {
        this.jcrData_.saveTemplate(str);
    }

    @Override
    public boolean isCategoryExist(String name, String path) {
        return this.jcrData_.isCategoryExist(name, path);
    }

    @Override
    public void updateQuestionRelatives(String questionPath, String[] relatives) throws Exception {
        this.jcrData_.updateQuestionRelatives(questionPath, relatives);
    }

    @Override
    public InputStream createAnswerRSS(String cateId) throws Exception {
        return this.jcrData_.createAnswerRSS(cateId);
    }

    @Override
    public void reCalculateLastActivityOfQuestion(String absPathOfProp) throws Exception {
        this.jcrData_.reCalculateInfoOfQuestion(absPathOfProp);
    }

    @Override
    public void addListenerPlugin(AnswerEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public void removeListenerPlugin(AnswerEventListener listener) throws Exception {
        this.listeners_.remove(listener);
    }

    @Override
    public void calculateDeletedUser(String userName) throws Exception {
        this.jcrData_.calculateDeletedUser(userName);
    }

    @Override
    public Object readCategoryProperty(String categoryId, String propertyName, Class returnType) throws Exception {
        return this.jcrData_.readCategoryProperty(categoryId, propertyName, returnType);
    }

    @Override
    public Object readQuestionProperty(String questionId, String propertyName, Class returnType) throws Exception {
        return this.jcrData_.readQuestionProperty(questionId, propertyName, returnType);
    }

    @Override
    public void saveActivityIdForQuestion(String ownerPath, String activityId) {
        this.jcrData_.saveActivityIdForQuestion(ownerPath, activityId);
    }

    @Override
    public String getActivityIdForQuestion(String ownerPath) {
        return this.jcrData_.getActivityIdForQuestion(ownerPath);
    }

    @Override
    public void saveActivityIdForAnswer(String ownerPath, Answer answer, String activityId) {
        this.jcrData_.saveActivityIdForAnswer(ownerPath, answer, activityId);
    }

    @Override
    public String getActivityIdForAnswer(String ownerPath, Answer answer) {
        return this.jcrData_.getActivityIdForAnswer(ownerPath, answer);
    }

    @Override
    public void saveActivityIdForComment(String ownerPath, String commentId, String language, String activityId) {
        this.jcrData_.saveActivityIdForComment(ownerPath, commentId, language, activityId);
    }

    @Override
    public String getActivityIdForComment(String ownerPath, String commentId, String language) {
        return this.jcrData_.getActivityIdForComment(ownerPath, commentId, language);
    }
}

