/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.embedder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.embedder.Embedder;
import org.exoplatform.social.common.embedder.ExoSocialMedia;
import org.json.JSONException;
import org.json.JSONObject;

public class YoutubeEmbedder
implements Embedder {
    private static final Log LOG = ExoLogger.getLogger(YoutubeEmbedder.class);
    private static final Pattern YOUTUBE_ID_PATTERN = Pattern.compile("(youtu\\.be\\/|youtube\\.com\\/(watch\\?(.*&)?v=|(embed|v)\\/))([^\\?&\"'>]+)");
    private static final Pattern CONTENT_URL_PATTERN = Pattern.compile(".*youtube\\.com\\/v\\/([^\\&\\?\\/]+)");
    private Map<Pattern, String> schemeEndpointMap = new HashMap<Pattern, String>();
    private Pattern youTubeURLPattern;
    private String url;

    public YoutubeEmbedder(InitParams initParams) {
        Iterator it = initParams.getValueParamIterator();
        ValueParam valueParam = null;
        while (it.hasNext()) {
            valueParam = (ValueParam)it.next();
            String youTubeReg = valueParam.getName().replaceAll("&amp;", "&");
            String youTubeFeedsURL = valueParam.getValue().replaceAll("&amp;", "&");
            this.youTubeURLPattern = Pattern.compile(youTubeReg);
            this.schemeEndpointMap.put(this.youTubeURLPattern, youTubeFeedsURL);
        }
    }

    public Pattern getYouTubeURLPattern() {
        return this.youTubeURLPattern;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public ExoSocialMedia getExoSocialMedia() {
        Matcher matcher;
        String feedsURL = null;
        for (Pattern pattern : this.schemeEndpointMap.keySet()) {
            matcher = pattern.matcher(this.url);
            if (matcher.find()) {
                feedsURL = this.schemeEndpointMap.get(pattern);
                continue;
            }
            return null;
        }
        JSONObject jsonObject = null;
        try {
            matcher = YOUTUBE_ID_PATTERN.matcher(this.url);
            String youtubeId = null;
            while (matcher.find()) {
                youtubeId = matcher.group(5);
            }
            String youTubeFeedURL = String.format(feedsURL, youtubeId);
            URL reqURL = new URL(youTubeFeedURL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(reqURL.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String eachLine = null;
            while ((eachLine = bufferedReader.readLine()) != null) {
                stringBuffer.append(eachLine);
            }
            bufferedReader.close();
            jsonObject = new JSONObject(stringBuffer.toString());
            JSONObject entryObject = jsonObject.getJSONObject("entry");
            String html = this.buildHtmlInfo(entryObject.getJSONObject("content"));
            if (html == null) {
                return null;
            }
            ExoSocialMedia mediaObject = new ExoSocialMedia();
            JSONObject mediaGroupObject = entryObject.getJSONObject("media$group");
            mediaObject.setTitle(entryObject.getJSONObject("title").getString("$t"));
            mediaObject.setHtml(html);
            mediaObject.setDescription(mediaGroupObject.has("media$description") ? mediaGroupObject.getJSONObject("media$description").getString("$t") : "");
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.debug((Object)"Any syntax error cause to JSON exception.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.debug((Object)"Problem with IO when open url.", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Problem occurred when get data from youtube link.", (Throwable)e);
            return null;
        }
    }

    private String buildHtmlInfo(JSONObject contentObject) throws JSONException {
        String videoContentURL = contentObject.getString("src");
        Matcher matcher = CONTENT_URL_PATTERN.matcher(videoContentURL);
        String contentSrc = null;
        while (matcher.find()) {
            contentSrc = matcher.group(0);
        }
        if (contentSrc == null) {
            LOG.info((Object)"Returned content url not match the pattern to get content source.");
            return null;
        }
        String videoPlayerType = contentObject.getString("type");
        StringBuilder contentURL = new StringBuilder();
        contentURL.append("<embed ").append("width=\"420\" height=\"345\" ").append("src=\"").append(contentSrc).append("\" type=\"").append(videoPlayerType).append("\">").append("</embed>");
        return contentURL.toString();
    }
}

