/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListenerStack;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipEventListenerHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.hibernate.HibernateListAccess;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.security.PermissionConstants;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOImpl
implements MembershipHandler,
MembershipEventListenerHandler {
    private static final String queryFindMembershipByUserGroupAndType = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.userName = :username and m.groupId = :groupid and m.membershipType = :membershiptype ";
    private static final String queryFindMembershipByType = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.membershipType = :membershiptype ";
    private static final String queryFindMembershipsByUserAndGroup = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.userName = :username and m.groupId = :groupid ";
    private static final String queryFindMembershipsByGroup = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.groupId = :groupid ";
    private static final String queryFindMembership = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.id = :id ";
    private static final String queryFindMembershipsByUser = "from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.userName = :username ";
    private HibernateService service_;
    private List<MembershipEventListener> listeners_;
    protected final OrganizationService orgService;

    public MembershipDAOImpl(HibernateService service, OrganizationService orgService) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ListenerStack(5);
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.add(listener);
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.remove(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        if (this.orgService.getMembershipTypeHandler().findMembershipType(m.getMembershipType()) == null) {
            throw new InvalidNameException("Can not create membership record " + m.getId() + ", because membership" + "type " + m.getMembershipType() + " does not exist.");
        }
        if (this.orgService.getGroupHandler().findGroupById(m.getGroupId()) == null) {
            throw new InvalidNameException("Can not create membership record " + m.getId() + ", because group " + m.getGroupId() + " does not exist.");
        }
        if (this.orgService.getUserHandler().findUserByName(m.getUserName()) == null) {
            throw new InvalidNameException("Can not create membership record " + m.getId() + ", because user " + m.getGroupId() + " does not exist.");
        }
        if (this.findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), m.getMembershipType()) != null) {
            return;
        }
        if (broadcast) {
            this.preSave(m, true);
        }
        Session session = this.service_.openSession();
        session.save((Object)m);
        session.flush();
        if (broadcast) {
            this.postSave(m, true);
        }
    }

    public void linkMembership(User user, Group g, MembershipType mt, boolean broadcast) throws Exception {
        if (user == null) {
            throw new InvalidNameException("Can not create membership record because user is null");
        }
        if (g == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
        }
        if (mt == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setUserName(user.getUserName());
        membership.setMembershipType(mt.getName());
        membership.setGroupId(g.getId());
        membership.setId(IdentifierUtil.generateUUID((Object)membership));
        this.createMembership((Membership)membership, broadcast);
    }

    public void saveMembership(Membership m, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(m, false);
        }
        Session session = this.service_.openSession();
        session.update((Object)m);
        session.flush();
        if (broadcast) {
            this.postSave(m, false);
        }
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        Membership m = (Membership)this.service_.findOne(session, queryFindMembership, id);
        if (m != null) {
            if (broadcast) {
                this.preDelete(m);
            }
            session.delete((Object)m);
            session.flush();
            if (broadcast) {
                this.postDelete(m);
            }
        }
        return m;
    }

    public Collection<?> removeMembershipByUser(String username, boolean broadcast) throws Exception {
        Collection<?> collection = this.findMembershipsByUser(username);
        for (Membership m : collection) {
            if (m == null) continue;
            if (broadcast) {
                this.preDelete(m);
            }
            Session session = this.service_.openSession();
            session.delete((Object)m);
            session.flush();
            if (!broadcast) continue;
            this.postDelete(m);
        }
        return collection;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembershipByUserGroupAndType).setString("username", userName).setString("groupid", groupId).setString("membershiptype", type).list();
        if (memberships.size() == 0) {
            return null;
        }
        if (memberships.size() == 1) {
            return (Membership)memberships.get(0);
        }
        throw new Exception("Expect 0 or 1 membership but found" + memberships.size());
    }

    public Collection<?> findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembershipsByUserAndGroup).setString("username", userName).setString("groupid", groupId).list();
        return memberships;
    }

    public Collection<?> findMembershipsByUser(String userName) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembershipsByUser).setString("username", userName).list();
        return memberships;
    }

    static void removeMembershipEntriesOfUser(String userName, Session session) throws Exception {
        List entries = session.createQuery(queryFindMembershipsByUser).setString("username", userName).list();
        for (int i = 0; i < entries.size(); ++i) {
            session.delete(entries.get(i));
        }
    }

    static void removeMembershipEntriesOfGroup(Group group, Session session) throws Exception {
        List entries = session.createQuery(queryFindMembershipsByGroup).setString("groupid", group.getId()).list();
        for (int i = 0; i < entries.size(); ++i) {
            session.delete(entries.get(i));
        }
    }

    static void removeMembershipEntriesOfMembershipType(MembershipType mt, Session session) throws Exception {
        List entries = session.createQuery(queryFindMembershipByType).setString("membershiptype", mt.getName()).list();
        for (int i = 0; i < entries.size(); ++i) {
            session.delete(entries.get(i));
        }
    }

    Collection<?> findMembershipsByUser(String userName, Session session) throws Exception {
        return session.createQuery(queryFindMembershipsByUser).setString("username", userName).list();
    }

    public Collection<?> findMembershipsByGroup(Group group) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembershipsByGroup).setString("groupid", group.getId()).list();
        return memberships;
    }

    public ListAccess<Membership> findAllMembershipsByGroup(Group group) throws Exception {
        String findQuery = "select m from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.groupId = '" + group.getId() + "'";
        String countQuery = "select count(m) from m in class org.exoplatform.services.organization.impl.MembershipImpl where m.groupId = '" + group.getId() + "'";
        return new HibernateListAccess<Membership>(this.service_, findQuery, countQuery);
    }

    public Collection<?> findMembershipsByGroupId(String groupId) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembershipsByGroup).setString("groupid", groupId).list();
        return memberships;
    }

    public Membership findMembership(String id) throws Exception {
        Session session = this.service_.openSession();
        List memberships = session.createQuery(queryFindMembership).setString("id", id).list();
        if (memberships.size() == 0) {
            throw new Exception("No membership with id: " + id + "found.");
        }
        if (memberships.size() == 1) {
            return (Membership)memberships.get(0);
        }
        throw new Exception("Found more than 1 membership: " + memberships.size());
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = this.listeners_.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = this.listeners_.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = this.listeners_.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = this.listeners_.get(i);
            listener.postDelete(membership);
        }
    }

    public List<MembershipEventListener> getMembershipListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }
}

