/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cms.link.ItemLinkAware;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.ItemLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NodeLocation
extends ItemLocation {
    private static final Log LOG = ExoLogger.getLogger((String)NodeLocation.class.getName());
    private List<NodeLocation> children_;

    public List<NodeLocation> getChildren() {
        return this.children_;
    }

    public void setChildren(List<NodeLocation> children) {
        this.children_ = children;
    }

    public boolean hasChildren() {
        return this.children_ != null && this.children_.size() > 0;
    }

    public NodeLocation() {
    }

    public NodeLocation(String repository, String workspace, String path, String uuid, boolean isSystem) {
        super(repository, workspace, path, uuid, isSystem);
    }

    public NodeLocation(String repository, String workspace, String path, String uuid) {
        super(repository, workspace, path, uuid, false);
    }

    public NodeLocation(String repository, String workspace, String path) {
        super(repository, workspace, path, null, false);
    }

    public NodeLocation(ItemLocation location) {
        super(location);
    }

    public static final NodeLocation getNodeLocationByExpression(String exp) {
        String[] temp = NodeLocation.split(exp, ":");
        if (temp.length >= 3 && temp[2].indexOf("/") == 0) {
            String repository = temp[0];
            String workspace = temp[1];
            String nodepath = exp.substring(repository.length() + workspace.length() + 2);
            return new NodeLocation(repository, workspace, nodepath);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    public static final NodeLocation getNodeLocationByNode(Node node) {
        try {
            ItemLocation itemLocation = ItemLocation.getItemLocationByItem((Item)node);
            return new NodeLocation(itemLocation);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final Node getNodeByLocation(NodeLocation nodeLocation) {
        try {
            Item item = ItemLocation.getItemByLocation(nodeLocation);
            return (Node)item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final List getNodeListByLocationList(List locationList) {
        ArrayList<Object> ret = new ArrayList<Object>();
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository();
            SessionProvider systemSessionProvider = WCMCoreUtils.getSystemSessionProvider();
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            String systemWorkspace = repository.getConfiguration().getSystemWorkspaceName();
            Session session = null;
            for (Object obj : locationList) {
                if (obj instanceof NodeLocation) {
                    Node node = null;
                    try {
                        NodeLocation location = (NodeLocation)obj;
                        session = systemWorkspace.equals(location.getWorkspace()) || location.isSystemSession ? systemSessionProvider.getSession(location.getWorkspace(), repository) : sessionProvider.getSession(location.getWorkspace(), repository);
                        node = location.getUUID() != null ? session.getNodeByUUID(location.getUUID()) : (Node)session.getItem(location.getPath());
                        ret.add(node);
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getMessage());
                    }
                    continue;
                }
                ret.add(obj);
            }
        }
        catch (Exception e) {
            return ret;
        }
        return ret;
    }

    public static final List getLocationsByNodeList(List nodeList) {
        ArrayList ret = new ArrayList();
        for (Object obj : nodeList) {
            if (obj instanceof ItemLinkAware) {
                ret.add(obj);
                continue;
            }
            if (obj instanceof Node) {
                NodeLocation location = NodeLocation.getNodeLocationByNode((Node)obj);
                if (location == null) continue;
                ret.add(location);
                continue;
            }
            ret.add(obj);
        }
        return ret;
    }

    public static final List<NodeLocation> getLocationsByIterator(NodeIterator nodeIterator) {
        ArrayList<NodeLocation> ret = new ArrayList<NodeLocation>();
        while (nodeIterator.hasNext()) {
            NodeLocation location = NodeLocation.getNodeLocationByNode(nodeIterator.nextNode());
            if (location == null) continue;
            ret.add(location);
        }
        return ret;
    }

    public static final Node getNodeByExpression(String expression) {
        return NodeLocation.getNodeByLocation(NodeLocation.getNodeLocationByExpression(expression));
    }

    public static final String getExpressionByNode(Node node) {
        NodeLocation location = NodeLocation.getNodeLocationByNode(node);
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public static final String getExpressionByNodeLocation(NodeLocation location) {
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public String toString() {
        return NodeLocation.mergeString(this.repository, this.workspace, this.path);
    }

    private static String mergeString(String repository, String workspace, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repository).append(":").append(workspace).append(":").append(path);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NodeLocation)) {
            return false;
        }
        NodeLocation location2 = (NodeLocation)obj;
        return this.equalsString(this.repository, location2.getRepository()) && this.equalsString(this.getWorkspace(), location2.getWorkspace()) && (this.equalsString(this.getPath(), location2.getPath()) || this.equalsString(this.getUUID(), location2.getUUID()));
    }

    public boolean equalsString(String st1, String st2) {
        if (st1 == null && st2 == null) {
            return true;
        }
        if (st1 == null || st2 == null) {
            return false;
        }
        return st1.equals(st2);
    }

    public int hashCode() {
        return (this.repository == null ? 0 : this.repository.hashCode()) + (this.workspace == null ? 0 : this.workspace.hashCode()) + (this.uuid == null ? 0 : this.uuid.hashCode()) + (this.path == null ? 0 : this.path.hashCode());
    }

    private static final String[] split(String s, String ch) {
        int maxLength = 3;
        String[] ss = new String[maxLength];
        int prev = 0;
        int i = 0;
        while (true) {
            int next;
            if ((next = s.indexOf(ch, prev)) == -1 || i == maxLength - 1) break;
            ss[i++] = s.substring(prev, next);
            prev = next + 1;
        }
        ss[i] = s.substring(prev);
        return ss;
    }
}

