/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeFilter;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortalImpl;

class UserNodeFilter
implements NodeFilter {
    private final UserPortalImpl userPortal;
    private final UserNodeFilterConfig config;

    public UserNodeFilter(UserPortalImpl userPortal, UserNodeFilterConfig config) {
        if (userPortal == null) {
            throw new NullPointerException();
        }
        if (config == null) {
            throw new NullPointerException();
        }
        this.userPortal = userPortal;
        this.config = config;
    }

    private boolean canRead(NodeState state) {
        PageKey pageRef = state.getPageRef();
        if (pageRef != null) {
            try {
                PageContext page = this.userPortal.service.getPageService().loadPage(pageRef);
                if (page != null) {
                    return this.userPortal.service.getUserACL().hasPermission(page);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean canWrite(NodeState state) {
        PageKey pageRef = state.getPageRef();
        if (pageRef != null) {
            try {
                PageContext page = this.userPortal.service.getPageService().loadPage(pageRef);
                if (page != null) {
                    return this.userPortal.service.getUserACL().hasEditPermission(page);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean accept(int depth, String id, String name, NodeState state) {
        Visibility visibility = state.getVisibility();
        if (visibility == null) {
            visibility = Visibility.DISPLAYED;
        }
        if (this.config.visibility != null && !this.config.visibility.contains((Object)visibility)) {
            return false;
        }
        if (!(depth <= 0 || this.config.path == null || depth - 1 < this.config.path.length && this.config.path[depth - 1].equals(name))) {
            return false;
        }
        UserACL acl = this.userPortal.service.getUserACL();
        if (this.config.authorizationMode != 0) {
            if (visibility == Visibility.SYSTEM) {
                if (this.config.authorizationMode == 2) {
                    String userName = this.userPortal.userName;
                    if (!acl.getSuperUser().equals(userName)) {
                        return false;
                    }
                } else if (!this.canRead(state)) {
                    return false;
                }
            } else if (this.config.authorizationMode == 2 ? !this.canRead(state) : !this.canRead(state)) {
                return false;
            }
        }
        switch (visibility) {
            case SYSTEM: {
                break;
            }
            case TEMPORAL: {
                if (!this.config.temporalCheck) break;
                long now = System.currentTimeMillis();
                if (state.getStartPublicationTime() != -1L && now < state.getStartPublicationTime()) {
                    return false;
                }
                if (state.getEndPublicationTime() == -1L || now <= state.getEndPublicationTime()) break;
                return false;
            }
        }
        return true;
    }
}

