/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.model;

import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ExoSocialActivityImpl
extends ActivityImpl
implements ExoSocialActivity {
    private ActivityStream activityStream;
    private boolean isAComment = false;
    private String type;
    private String[] replyToId;
    private boolean isHiddenActivity = false;
    private boolean isLockedActivity = false;
    private String[] likeIdentityIds;
    private String name;
    private String summary;
    private transient String permaLink;
    private String[] mentionedIds;
    private String[] commentedIds;
    private String posterId;

    public ExoSocialActivityImpl() {
        this.init();
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle) {
        this.init();
        this.setUserId(userId);
        this.type = activityType;
        this.setTitle(activityTitle);
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle, String activityBody) {
        this(userId, activityType, activityTitle);
        this.setBody(activityBody);
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle, String activityBody, boolean isAComment) {
        this(userId, activityType, activityTitle);
        this.setBody(activityBody);
        this.isAComment = isAComment;
    }

    @Override
    public final ActivityStream getActivityStream() {
        if (this.activityStream == null) {
            this.activityStream = new ActivityStreamImpl();
        }
        return this.activityStream;
    }

    @Override
    public final void setActivityStream(ActivityStream providedAS) {
        this.activityStream = providedAS;
    }

    @Override
    public final boolean isComment() {
        return this.isAComment;
    }

    @Override
    public final void isComment(boolean isCommentOrNot) {
        this.isAComment = isCommentOrNot;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final void setType(String activityType) {
        this.type = activityType;
    }

    @Override
    public String[] getReplyToId() {
        return this.replyToId;
    }

    @Override
    public final void setReplyToId(String[] replyToIdentityId) {
        this.replyToId = replyToIdentityId;
    }

    @Override
    public final boolean isHidden() {
        return this.isHiddenActivity;
    }

    @Override
    public final void isHidden(boolean isHiddenOrNot) {
        this.isHiddenActivity = isHiddenOrNot;
    }

    @Override
    public final boolean isLocked() {
        return this.isLockedActivity;
    }

    @Override
    public final void isLocked(boolean isLockedOrNot) {
        this.isLockedActivity = isLockedOrNot;
    }

    @Override
    public final String[] getLikeIdentityIds() {
        if (this.likeIdentityIds != null) {
            return Arrays.copyOf(this.likeIdentityIds, this.likeIdentityIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public int getNumberOfLikes() {
        return this.likeIdentityIds == null ? 0 : this.likeIdentityIds.length;
    }

    @Override
    public final void setLikeIdentityIds(String[] identityIds) {
        this.likeIdentityIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public final String getStreamOwner() {
        return this.activityStream.getPrettyId();
    }

    @Override
    public final void setStreamOwner(String activitySO) {
        this.activityStream.setPrettyId(activitySO);
    }

    @Override
    public final String getStreamId() {
        return this.activityStream.getId();
    }

    @Override
    public final void setStreamId(String sId) {
        this.activityStream.setId(sId);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String activityName) {
        this.name = activityName;
    }

    @Override
    public final String getSummary() {
        return this.summary;
    }

    @Override
    public final void setSummary(String activitySummary) {
        this.summary = activitySummary;
    }

    @Override
    public final String getPermaLink() {
        return this.permaLink;
    }

    @Override
    public final void setPermanLink(String activityPermaLink) {
        this.permaLink = activityPermaLink;
    }

    public final String getStreamFaviconUrl() {
        return this.activityStream.getFaviconUrl();
    }

    public final String getStreamSourceUrl() {
        return this.activityStream.getPermaLink();
    }

    public final String getStreamTitle() {
        return this.activityStream.getTitle();
    }

    public final String getStreamUrl() {
        return this.activityStream.getPermaLink();
    }

    @Override
    public final String[] getMentionedIds() {
        if (this.mentionedIds != null) {
            return Arrays.copyOf(this.mentionedIds, this.mentionedIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public final void setMentionedIds(String[] identityIds) {
        this.mentionedIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public final String[] getCommentedIds() {
        if (this.commentedIds != null) {
            return Arrays.copyOf(this.commentedIds, this.commentedIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public final void setCommentedIds(String[] identityIds) {
        this.commentedIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public void setUpdated(Long updated) {
        if (updated != null) {
            this.setUpdated(new Date(updated));
        } else {
            this.setUpdated(new Date(System.currentTimeMillis()));
        }
    }

    private void init() {
        Date date = new Date();
        this.setPostedTime(date.getTime());
        this.setUpdated(date);
        this.activityStream = new ActivityStreamImpl();
    }

    @Override
    public String getPosterId() {
        return this.posterId;
    }

    @Override
    public void setPosterId(String posterId) {
        this.posterId = posterId;
    }
}

