/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class MentionsProcessor
extends BaseActivityProcessorPlugin {
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");

    public MentionsProcessor(InitParams params) {
        super(params);
    }

    @Override
    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            activity.setTitle(this.substituteUsernames(activity.getTitle()));
            activity.setBody(this.substituteUsernames(activity.getBody()));
            Map templateParams = activity.getTemplateParams();
            List<String> templateParamKeys = this.getTemplateParamKeysToFilter(activity);
            for (String key : templateParamKeys) {
                templateParams.put(key, this.substituteUsernames((String)templateParams.get(key)));
            }
        }
    }

    private String substituteUsernames(String message) {
        if (message == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String replaceStr = matcher.group().substring(1);
            String portalOwner = null;
            try {
                portalOwner = Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                portalOwner = LinkProvider.DEFAULT_PORTAL_OWNER;
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            LinkProvider lp = (LinkProvider)container.getComponentInstanceOfType(LinkProvider.class);
            IdentityManager identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", replaceStr, false);
            if (identity == null) continue;
            if ((replaceStr = LinkProvider.getProfileLink(replaceStr, portalOwner)) == null) continue;
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

