/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.model.data.ActivityData;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListActivitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListSpacesData;
import org.exoplatform.social.core.storage.cache.model.data.ProfileData;
import org.exoplatform.social.core.storage.cache.model.data.RelationshipData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceData;
import org.exoplatform.social.core.storage.cache.model.key.ActivityCountKey;
import org.exoplatform.social.core.storage.cache.model.key.ActivityKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityCompositeKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListActivitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListRelationshipsKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpacesKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipCountKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipIdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceRefKey;

public class SocialStorageCacheService {
    private final ExoCache<IdentityKey, IdentityData> identityCache;
    private final ExoCache<IdentityCompositeKey, IdentityKey> identityIndexCache;
    private final ExoCache<IdentityKey, ProfileData> profileCache;
    private final ExoCache<IdentityFilterKey, IntegerData> countIdentitiesCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> identitiesCache;
    private final ExoCache<RelationshipKey, RelationshipData> relationshipCache;
    private final ExoCache<RelationshipIdentityKey, RelationshipKey> relationshipCacheByIdentity;
    private final ExoCache<RelationshipCountKey, IntegerData> relationshipsCount;
    private final ExoCache<ListRelationshipsKey, ListIdentitiesData> relationshipsCache;
    private final ExoCache<ActivityKey, ActivityData> activityCache;
    private final ExoCache<ActivityCountKey, IntegerData> activitiesCountCache;
    private final ExoCache<ListActivitiesKey, ListActivitiesData> activitiesCache;
    private final ExoCache<SpaceKey, SpaceData> spaceCache;
    private final ExoCache<SpaceRefKey, SpaceKey> spaceRefCache;
    private final ExoCache<SpaceFilterKey, IntegerData> spacesCountCache;
    private final ExoCache<ListSpacesKey, ListSpacesData> spacesCache;

    public SocialStorageCacheService(CacheService cacheService) {
        this.identityCache = CacheType.IDENTITY.getFromService(cacheService);
        this.identityIndexCache = CacheType.IDENTITY_INDEX.getFromService(cacheService);
        this.profileCache = CacheType.PROFILE.getFromService(cacheService);
        this.countIdentitiesCache = CacheType.IDENTITIES_COUNT.getFromService(cacheService);
        this.identitiesCache = CacheType.IDENTITIES.getFromService(cacheService);
        this.relationshipCache = CacheType.RELATIONSHIP.getFromService(cacheService);
        this.relationshipCacheByIdentity = CacheType.RELATIONSHIP_FROM_IDENTITY.getFromService(cacheService);
        this.relationshipsCount = CacheType.RELATIONSHIPS_COUNT.getFromService(cacheService);
        this.relationshipsCache = CacheType.RELATIONSHIPS.getFromService(cacheService);
        this.activityCache = CacheType.ACTIVITY.getFromService(cacheService);
        this.activitiesCountCache = CacheType.ACTIVITIES_COUNT.getFromService(cacheService);
        this.activitiesCache = CacheType.ACTIVITIES.getFromService(cacheService);
        this.spaceCache = CacheType.SPACE.getFromService(cacheService);
        this.spaceRefCache = CacheType.SPACE_REF.getFromService(cacheService);
        this.spacesCountCache = CacheType.SPACES_COUNT.getFromService(cacheService);
        this.spacesCache = CacheType.SPACES.getFromService(cacheService);
    }

    public ExoCache<IdentityKey, IdentityData> getIdentityCache() {
        return this.identityCache;
    }

    public ExoCache<IdentityCompositeKey, IdentityKey> getIdentityIndexCache() {
        return this.identityIndexCache;
    }

    public ExoCache<IdentityKey, ProfileData> getProfileCache() {
        return this.profileCache;
    }

    public ExoCache<IdentityFilterKey, IntegerData> getCountIdentitiesCache() {
        return this.countIdentitiesCache;
    }

    public ExoCache<ListIdentitiesKey, ListIdentitiesData> getIdentitiesCache() {
        return this.identitiesCache;
    }

    public ExoCache<RelationshipKey, RelationshipData> getRelationshipCache() {
        return this.relationshipCache;
    }

    public ExoCache<RelationshipIdentityKey, RelationshipKey> getRelationshipCacheByIdentity() {
        return this.relationshipCacheByIdentity;
    }

    public ExoCache<RelationshipCountKey, IntegerData> getRelationshipsCount() {
        return this.relationshipsCount;
    }

    public ExoCache<ListRelationshipsKey, ListIdentitiesData> getRelationshipsCache() {
        return this.relationshipsCache;
    }

    public ExoCache<ActivityKey, ActivityData> getActivityCache() {
        return this.activityCache;
    }

    public ExoCache<ActivityCountKey, IntegerData> getActivitiesCountCache() {
        return this.activitiesCountCache;
    }

    public ExoCache<ListActivitiesKey, ListActivitiesData> getActivitiesCache() {
        return this.activitiesCache;
    }

    public ExoCache<SpaceKey, SpaceData> getSpaceCache() {
        return this.spaceCache;
    }

    public ExoCache<SpaceRefKey, SpaceKey> getSpaceRefCache() {
        return this.spaceRefCache;
    }

    public ExoCache<SpaceFilterKey, IntegerData> getSpacesCountCache() {
        return this.spacesCountCache;
    }

    public ExoCache<ListSpacesKey, ListSpacesData> getSpacesCache() {
        return this.spacesCache;
    }
}

