/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.query;

import org.exoplatform.social.core.storage.query.CallExpression;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.QueryFunction;

public class WhereExpression {
    private static final String QUOTED = "'%s'";
    private static final String DIRECT = "%s";
    ThreadLocal<StringBuilder> sbLocal = new ThreadLocal();
    private int openGroup = 0;

    public WhereExpression() {
        this.getStringBuilder();
    }

    public final StringBuilder getStringBuilder() {
        if (this.sbLocal.get() == null) {
            this.sbLocal.set(new StringBuilder());
        }
        return this.sbLocal.get();
    }

    public final void destroy() {
        if (this.sbLocal.get() != null) {
            this.sbLocal.set(null);
        }
    }

    public <T> WhereExpression isNull(PropertyLiteralExpression<T> property) {
        this.getStringBuilder().append(String.format("%s Is NULL ", property.getName()));
        return this;
    }

    public <T> WhereExpression equals(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s = %s ", property.getName(), this.espace(property, value)));
        return this;
    }

    public <T> WhereExpression lesser(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s < %s ", property.getName(), value));
        return this;
    }

    public <T> WhereExpression lessEq(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s <= %s ", property.getName(), value));
        return this;
    }

    public <T> WhereExpression greater(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s > %s ", property.getName(), this.espace(property, value)));
        return this;
    }

    public <T> WhereExpression greaterEq(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s >= '%s' ", property.getName(), value));
        return this;
    }

    public <T> WhereExpression like(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("%s LIKE %s ", property.getName(), this.espace(property, value)));
        return this;
    }

    public <T> WhereExpression like(CallExpression<T> call, T value) {
        this.checkParam(call.getProperty(), value);
        this.getStringBuilder().append(String.format("%s(%s) LIKE %s ", new Object[]{call.getFunction(), call.getProperty().getName(), this.espace(call.getProperty(), value)}));
        return this;
    }

    public <T> WhereExpression contains(PropertyLiteralExpression<T> property, T value) {
        this.checkParam(property, value);
        this.getStringBuilder().append(String.format("CONTAINS (%s, '%s') ", property.getName(), value));
        return this;
    }

    public <T> WhereExpression contains(CallExpression<T> call, T value) {
        this.checkParam(call.getProperty(), value);
        this.getStringBuilder().append(String.format("CONTAINS (%s(%s), %s) ", new Object[]{call.getFunction(), call.getProperty().getName(), this.espace(call.getProperty(), value)}));
        return this;
    }

    public WhereExpression startGroup() {
        this.getStringBuilder().append("(");
        ++this.openGroup;
        return this;
    }

    public WhereExpression endGroup() {
        this.getStringBuilder().append(") ");
        --this.openGroup;
        return this;
    }

    public WhereExpression endAllGroup() {
        while (this.openGroup > 0) {
            this.endGroup();
        }
        return this;
    }

    public WhereExpression not() {
        this.getStringBuilder().append("NOT ");
        return this;
    }

    public WhereExpression or() {
        this.getStringBuilder().append("OR ");
        return this;
    }

    public WhereExpression and() {
        this.getStringBuilder().append("AND ");
        return this;
    }

    public String toString() {
        return this.getStringBuilder().toString();
    }

    public <T> CallExpression callFunction(QueryFunction function, PropertyLiteralExpression<T> property) {
        return new CallExpression<T>(function, property);
    }

    private <T> String espace(PropertyLiteralExpression<T> property, T value) {
        String format;
        String string = format = property.getType().equals(Long.class) ? DIRECT : QUOTED;
        if (value instanceof String) {
            String strValue = ((String)value).replaceAll("'", "''");
            return String.format(format, strValue);
        }
        return String.format(format, value);
    }

    private <T> void checkParam(PropertyLiteralExpression<T> property, T value) {
        if (!property.getType().equals(value.getClass())) {
            throw new IllegalArgumentException();
        }
    }
}

