/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.io.IOException;

public class Quantifier {
    private final Mode mode;
    private final Range range;

    public Quantifier(Mode mode, int min, Integer max) {
        if (mode == null) {
            throw new NullPointerException("No null mode accepted");
        }
        this.mode = mode;
        this.range = new Range(min, max);
    }

    public Quantifier(Mode mode, Range range) {
        if (mode == null) {
            throw new NullPointerException("No null mode accepted");
        }
        if (range == null) {
            throw new NullPointerException("No null range accepted");
        }
        this.mode = mode;
        this.range = range;
    }

    public int getMin() {
        return this.range.min;
    }

    public static Quantifier onceOrNotAtAll(Mode mode) {
        return new Quantifier(mode, 0, 1);
    }

    public static Quantifier zeroOrMore(Mode mode) {
        return new Quantifier(mode, 0, null);
    }

    public static Quantifier oneOrMore(Mode mode) {
        return new Quantifier(mode, 1, null);
    }

    public static Quantifier exactly(Mode mode, int value) {
        return new Quantifier(mode, value, value);
    }

    public static Quantifier atLeast(Mode mode, int value) {
        return new Quantifier(mode, value, null);
    }

    public static Quantifier between(Mode mode, int min, int max) {
        return new Quantifier(mode, min, max);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Quantifier) {
            Quantifier that = (Quantifier)o;
            return this.mode == that.mode && this.range.equals(that.range);
        }
        return false;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void toString(Appendable appendable) throws IOException {
        if (this.range.min == 0) {
            if (this.range.max == null) {
                appendable.append('*').append(this.mode.value);
            } else if (this.range.max == 1) {
                appendable.append('?').append(this.mode.value);
            }
        } else if (this.range.min == 1 && this.range.max == null) {
            appendable.append('+').append(this.mode.value);
        } else if (this.range.max == null) {
            appendable.append('{').append(Integer.toString(this.range.min)).append(",").append('}').append(this.mode.value);
        } else if (this.range.min == this.range.max) {
            appendable.append('{').append(Integer.toString(this.range.min)).append('}').append(this.mode.value);
        } else {
            appendable.append('{').append(Integer.toString(this.range.min)).append(",").append(this.range.max.toString()).append('}').append(this.mode.value);
        }
    }

    public static class Range {
        private final int min;
        private final Integer max;

        public Range(int min, Integer max) {
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Range) {
                Range that = (Range)o;
                return this.min == that.min && (this.max == null ? that.max == null : this.max.equals(that.max));
            }
            return false;
        }

        public static Range onceOrNotAtAll() {
            return new Range(0, 1);
        }

        public static Range zeroOrMore() {
            return new Range(0, null);
        }

        public static Range oneOrMore() {
            return new Range(1, null);
        }

        public static Range exactly(int value) {
            return new Range(value, value);
        }

        public static Range atLeast(int value) {
            return new Range(value, null);
        }

        public static Range between(int min, int max) {
            return new Range(min, max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        GREEDY(""),
        RELUCTANT("?"),
        POSSESSIVE("+");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }
    }
}

