/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:((\\w+\\.)+prototype\\.)*(setUpPage|setUp|tearDown|tearDownPage|test\\w+))$");
    private AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    ExportTestFunctions(AbstractCompiler compiler, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ExportTestFunctionsNodes());
    }

    private void exportTestFunctionAsSymbol(String testFunctionName, Node node, Node scriptNode) {
        Node exportCallTarget = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportSymbolFunction, node, testFunctionName);
        Node call = new Node(37, exportCallTarget);
        if (exportCallTarget.isName()) {
            call.putBooleanProp(50, true);
        }
        call.addChildToBack(Node.newString(testFunctionName));
        call.addChildToBack(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), testFunctionName, node, testFunctionName));
        Node expression = new Node(130, call);
        scriptNode.addChildAfter(expression, node);
        this.compiler.reportCodeChange();
    }

    private void exportTestFunctionAsProperty(String fullyQualifiedFunctionName, Node parent, Node node, Node scriptNode) {
        String testFunctionName = NodeUtil.getPrototypePropertyName(node.getFirstChild());
        String objectName = fullyQualifiedFunctionName.substring(0, fullyQualifiedFunctionName.lastIndexOf(46));
        String exportCallStr = String.format("%s(%s, '%s', %s);", this.exportPropertyFunction, objectName, testFunctionName, fullyQualifiedFunctionName);
        Node exportCall = this.compiler.parseSyntheticCode(exportCallStr).removeChildren();
        exportCall.useSourceInfoFromForTree(scriptNode);
        scriptNode.addChildAfter(exportCall, parent);
        this.compiler.reportCodeChange();
    }

    private boolean isTestFunction(Node n, String functionName) {
        return functionName != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(functionName).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractShallowCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String functionName;
            Node grandparent;
            if (parent == null) {
                return;
            }
            if (parent.isScript()) {
                String functionName2;
                Node functionNode;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    String functionName3 = NodeUtil.getFunctionName(n);
                    if (ExportTestFunctions.this.isTestFunction(n, functionName3)) {
                        ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName3, n, parent);
                    }
                } else if (this.isVarDeclaredFunction(n) && ExportTestFunctions.this.isTestFunction(functionNode = n.getFirstChild().getFirstChild(), functionName2 = NodeUtil.getFunctionName(functionNode))) {
                    ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName2, n, parent);
                }
            } else if (NodeUtil.isExprAssign(parent) && n.getLastChild().getType() != 86 && (grandparent = parent.getParent()) != null && grandparent.isScript() && ExportTestFunctions.this.isTestFunction(n, functionName = n.getFirstChild().getQualifiedName())) {
                ExportTestFunctions.this.exportTestFunctionAsProperty(functionName, parent, n, grandparent);
            }
        }

        private boolean isVarDeclaredFunction(Node node) {
            if (node.getType() != 118) {
                return false;
            }
            Node grandchild = node.getFirstChild().getFirstChild();
            return grandchild != null && grandchild.isFunction();
        }
    }
}

