/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates.clv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.clv.UICLVTemplateContainer;
import org.exoplatform.ecm.webui.component.admin.templates.clv.UICLVTemplateForm;
import org.exoplatform.ecm.webui.component.admin.templates.clv.UICLVTemplatesManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UICLVTemplateList.msg.confirm-delete"), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={AddTemplateActionListener.class})})
public class UICLVTemplateList
extends UIPagingGrid {
    private static String[] NODETYPE_BEAN_FIELD = new String[]{"title", "template"};
    private static String[] NODETYPE_ACTION = new String[]{"Edit", "Delete"};
    private String filter = "contents";

    public UICLVTemplateList() throws Exception {
        this.configure("template", NODETYPE_BEAN_FIELD, NODETYPE_ACTION);
    }

    public void setTemplateFilter(String filter) {
        this.filter = filter;
    }

    public String getTemplateFilter() {
        return this.filter;
    }

    public String[] getActions() {
        return new String[]{"AddTemplate"};
    }

    public void refresh(int currentPage) throws Exception {
        ApplicationTemplateManagerService templateService = (ApplicationTemplateManagerService)WCMCoreUtils.getService(ApplicationTemplateManagerService.class);
        List<Object> templateData = new ArrayList();
        if (this.filter.equals("contents")) {
            templateData = this.convetListNodeToListData(templateService.getTemplatesByCategory("content-list-viewer", "list", WCMCoreUtils.getUserSessionProvider()));
        } else if (this.filter.equals("category")) {
            templateData = this.convetListNodeToListData(templateService.getTemplatesByCategory("content-list-viewer", "navigation", WCMCoreUtils.getUserSessionProvider()));
        } else if (this.filter.equals("paginators")) {
            templateData = this.convetListNodeToListData(templateService.getTemplatesByCategory("content-list-viewer", "paginators", WCMCoreUtils.getUserSessionProvider()));
        }
        Collections.sort(templateData, new CLVTemplateComparator());
        ListAccessImpl dataList = new ListAccessImpl(CLVTemplateData.class, templateData);
        LazyPageList pageList = new LazyPageList((ListAccess)dataList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setTotalItems(templateData.size());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    private List<CLVTemplateData> convetListNodeToListData(List<Node> list) throws RepositoryException {
        ArrayList<CLVTemplateData> templateDatas = new ArrayList<CLVTemplateData>();
        for (Node node : list) {
            Node content = node.getNode("jcr:content");
            try {
                templateDatas.add(new CLVTemplateData(content.getProperty("dc:title").getValues()[0].getString(), node.getName()));
            }
            catch (PathNotFoundException pne) {
                templateDatas.add(new CLVTemplateData(node.getName(), node.getName()));
            }
            catch (ArrayIndexOutOfBoundsException aoe) {
                templateDatas.add(new CLVTemplateData(node.getName(), node.getName()));
            }
        }
        return templateDatas;
    }

    private String getCategoryFromFilter() {
        if (this.filter.equals("contents")) {
            return "list";
        }
        if (this.filter.equals("category")) {
            return "navigation";
        }
        if (this.filter.equals("paginators")) {
            return "paginators";
        }
        return null;
    }

    public static class CLVTemplateData {
        private String title;
        private String template;

        public CLVTemplateData(String title, String template) {
            this.title = title;
            this.template = template;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTemplate() {
            return this.template;
        }
    }

    public static class CLVTemplateComparator
    implements Comparator<CLVTemplateData> {
        @Override
        public int compare(CLVTemplateData t1, CLVTemplateData t2) throws ClassCastException {
            String title1 = t1.getTitle();
            String title2 = t2.getTitle();
            return title1.compareToIgnoreCase(title2);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UICLVTemplateList> {
        public void execute(Event<UICLVTemplateList> event) throws Exception {
            UICLVTemplateList clvTemplateList = (UICLVTemplateList)((Object)event.getSource());
            UICLVTemplatesManager uiTemplatesManager = (UICLVTemplatesManager)clvTemplateList.getAncestorOfType(UICLVTemplatesManager.class);
            if (uiTemplatesManager.isEditingTemplate()) {
                UIApplication uiApp = (UIApplication)((UICLVTemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UICLVTemplateList.msg.editing-template", null, 1));
                return;
            }
            String template = event.getRequestContext().getRequestParameter("objectId");
            ApplicationTemplateManagerService templateService = (ApplicationTemplateManagerService)clvTemplateList.getApplicationComponent(ApplicationTemplateManagerService.class);
            try {
                templateService.removeTemplate("content-list-viewer", clvTemplateList.getCategoryFromFilter(), template, WCMCoreUtils.getUserSessionProvider());
            }
            catch (PathNotFoundException ex) {
                UIApplication uiApp = (UIApplication)((UICLVTemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITCLVemplateList.msg.template-not-exist", null, 1));
                return;
            }
            clvTemplateList.refresh(clvTemplateList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }

    public static class AddTemplateActionListener
    extends EventListener<UICLVTemplateList> {
        public void execute(Event<UICLVTemplateList> event) throws Exception {
            UICLVTemplateList uiList = (UICLVTemplateList)((Object)event.getSource());
            UICLVTemplatesManager uiTemplatesManager = (UICLVTemplatesManager)uiList.getAncestorOfType(UICLVTemplatesManager.class);
            UICLVTemplateContainer uiTemplateContainer = (UICLVTemplateContainer)uiTemplatesManager.getChildById(uiTemplatesManager.getSelectedTabId());
            UICLVTemplateForm uiTemplateForm = (UICLVTemplateForm)uiTemplateContainer.createUIComponent(UICLVTemplateForm.class, null, "UICLVTemplateForm_" + uiTemplatesManager.getSelectedTabId());
            uiTemplateContainer.removeChildById("EditCLVTemplatePopup_" + uiTemplatesManager.getSelectedTabId());
            uiTemplateForm.refresh(uiList.getCategoryFromFilter());
            uiTemplateContainer.initPopup((UIComponent)uiTemplateForm, "CLVTemplatePopup_" + uiTemplatesManager.getSelectedTabId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }

    public static class EditActionListener
    extends EventListener<UICLVTemplateList> {
        public void execute(Event<UICLVTemplateList> event) throws Exception {
            UICLVTemplateList clvTemplateList = (UICLVTemplateList)((Object)event.getSource());
            UICLVTemplatesManager uiTemplatesManager = (UICLVTemplatesManager)clvTemplateList.getAncestorOfType(UICLVTemplatesManager.class);
            UICLVTemplateContainer uiTemplateContainer = (UICLVTemplateContainer)uiTemplatesManager.getChildById(uiTemplatesManager.getSelectedTabId());
            UICLVTemplateForm uiTemplateForm = (UICLVTemplateForm)uiTemplateContainer.createUIComponent(UICLVTemplateForm.class, null, "UICLVTemplateForm_" + uiTemplatesManager.getSelectedTabId());
            String template = event.getRequestContext().getRequestParameter("objectId");
            uiTemplateForm.update(clvTemplateList.getCategoryFromFilter(), template);
            uiTemplateContainer.removeChildById("CLVTemplatePopup_" + uiTemplatesManager.getSelectedTabId());
            uiTemplateContainer.initPopup((UIComponent)uiTemplateForm, "EditCLVTemplatePopup_" + uiTemplatesManager.getSelectedTabId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }
}

