/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.views.UITabContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITabList;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="app:/groovy/webui/component/admin/view/UITabForm.gtmpl", lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITabForm
extends UIForm {
    public static final String FIELD_NAME = "tabName";
    private List<?> buttons_;

    public UITabForm() throws Exception {
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        ManageViewService vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.buttons_ = vservice_.getButtons();
        for (Object bt : this.buttons_) {
            this.addUIFormInput((UIFormInput)new UICheckBoxInput(this.getButtonName(bt), "", null));
        }
    }

    private String getButtonName(Object bt) {
        String button = (String)bt;
        return button.substring(0, 1).toLowerCase() + button.substring(1);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void refresh(boolean isEditable) throws Exception {
        this.getUIStringInput(FIELD_NAME).setDisabled(!isEditable).setValue(null);
        for (Object bt : this.buttons_) {
            this.getUICheckBoxInput(this.getButtonName(bt)).setChecked(false).setDisabled(!isEditable);
        }
    }

    public void update(ViewConfig.Tab tab, boolean isView) throws Exception {
        String[] buttonArray;
        this.refresh(!isView);
        if (tab == null) {
            return;
        }
        this.getUIStringInput(FIELD_NAME).setDisabled(true).setValue((Object)tab.getTabName());
        String buttonsProperty = tab.getButtons();
        for (String bt : buttonArray = StringUtils.split((String)buttonsProperty, (String)";")) {
            UICheckBoxInput cbInput = this.getUICheckBoxInput(bt.trim());
            if (cbInput == null) continue;
            cbInput.setChecked(true);
        }
    }

    public static class CancelActionListener
    extends EventListener<UITabForm> {
        public void execute(Event<UITabForm> event) throws Exception {
            UITabForm uiTabForm = (UITabForm)((Object)event.getSource());
            UITabContainer uiContainer = (UITabContainer)uiTabForm.getAncestorOfType(UITabContainer.class);
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiContainer.getParent();
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById("TabForm_Popup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            uiTabPane.setSelectedTab(uiContainer.getId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UITabForm> {
        public void execute(Event<UITabForm> event) throws Exception {
            String[] arrFilterChar;
            UITabForm uiTabForm = (UITabForm)((Object)event.getSource());
            UITabContainer uiContainer = (UITabContainer)uiTabForm.getAncestorOfType(UITabContainer.class);
            UIViewFormTabPane viewFormTabPane = (UIViewFormTabPane)uiContainer.getParent();
            String tabName = (String)uiTabForm.getUIStringInput(UITabForm.FIELD_NAME).getValue();
            UIApplication uiApp = (UIApplication)((UITabForm)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            if (tabName == null || tabName.trim().length() == 0) {
                viewFormTabPane.setSelectedTab(uiTabForm.getId());
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.tab-name-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTabForm);
                return;
            }
            for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!"}) {
                if (tabName.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.fileName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTabForm);
                return;
            }
            StringBuilder selectedButton = new StringBuilder();
            boolean isSelected = false;
            for (Object bt : uiTabForm.buttons_) {
                String button = uiTabForm.getButtonName(bt);
                if (!uiTabForm.getUICheckBoxInput(button).isChecked()) continue;
                isSelected = true;
                if (selectedButton.length() > 0) {
                    selectedButton.append(";").append(button);
                    continue;
                }
                selectedButton.append(button);
            }
            if (!isSelected) {
                viewFormTabPane.setSelectedTab(uiTabForm.getId());
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.button-select-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTabForm);
                return;
            }
            UIViewForm uiViewForm = (UIViewForm)viewFormTabPane.getChild(UIViewForm.class);
            uiViewForm.addTab(tabName, selectedButton.toString());
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById("TabForm_Popup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            viewFormTabPane.setSelectedTab(viewFormTabPane.getSelectedTabId());
            UITabList uiTabList = (UITabList)uiContainer.getChild(UITabList.class);
            uiTabList.refresh(uiTabList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }
}

