/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ForumStatistics;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsWeeklyStatistic;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsWeeklyStatisticService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ForumsWeeklyStatisticJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(ForumsWeeklyStatisticJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
            ForumsWeeklyStatisticService service = (ForumsWeeklyStatisticService)containerContext.getComponentInstanceOfType(ForumsWeeklyStatisticService.class);
            ForumsWeeklyStatistic weeklyStatistic = service.getLastForumsWeeklyStatistic();
            if (this.isAddNew(weeklyStatistic)) {
                weeklyStatistic = new ForumsWeeklyStatistic();
                weeklyStatistic.setStartDate(new Date());
                weeklyStatistic.setLastStatEntry(new Date());
                weeklyStatistic.setPostsCountOfWeek(service.getPostCountForumStatistic());
                weeklyStatistic.setStartPostsCountOfWeek(service.getPostCountForumStatistic());
            } else {
                weeklyStatistic.setLastStatEntry(new Date());
                weeklyStatistic.setPostsCountOfWeek(service.getPostCountForumStatistic() > weeklyStatistic.getStartPostsCountOfWeek() ? service.getPostCountForumStatistic() - weeklyStatistic.getStartPostsCountOfWeek() : 0L);
            }
            service.saveForumsWeeklyStatistic(weeklyStatistic);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to update ForumsWeeklyStatistic", (Throwable)e);
        }
    }

    private boolean isAddNew(ForumsWeeklyStatistic weeklyStatistic) {
        if (weeklyStatistic == null) {
            return true;
        }
        Calendar now = GregorianCalendar.getInstance();
        Calendar startDate = GregorianCalendar.getInstance();
        startDate.setTime(weeklyStatistic.getStartDate());
        return now.get(3) != startDate.get(3);
    }
}

