/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NameValidator;
import org.exoplatform.webui.form.validator.NotHTMLTagValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.organization.UIListPermissionSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIContainerPermission", type=UIFormInputSet.class, lifecycle=UIContainerLifecycle.class)})
public class UIContainerForm
extends UIFormTabPane {
    private UIContainer uiContainer_;
    private UIComponent backComponent_;

    public UIContainerForm() throws Exception {
        super("UIContainerForm");
        UIFormInputSet infoInputSet = new UIFormInputSet("ContainerSetting");
        infoInputSet.addUIFormInput((UIFormInput)new UIFormStringInput("id", "id", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(NameValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput("title", "title", null).addValidator(StringLengthValidator.class, new Object[]{50}).addValidator(NotHTMLTagValidator.class, new Object[]{"UIContainerForm.msg.InvalidContainerTitle"})).addUIFormInput((UIFormInput)new UIFormStringInput("width", "width", null).addValidator(ExpressionValidator.class, new Object[]{"(^([1-9]\\d*)(px|%)$)?", "UIContainerForm.msg.InvalidWidthHeight"})).addUIFormInput((UIFormInput)new UIFormStringInput("height", "height", null).addValidator(ExpressionValidator.class, new Object[]{"(^([1-9]\\d*)(px|%)$)?", "UIContainerForm.msg.InvalidWidthHeight"}));
        this.addChild((UIComponent)infoInputSet);
        this.setSelectedTab(infoInputSet.getId());
        UIListPermissionSelector uiListPermissionSelector = (UIListPermissionSelector)this.createUIComponent(UIListPermissionSelector.class, null, null);
        uiListPermissionSelector.configure("ContainerPermissionSelector", "accessPermissions");
        uiListPermissionSelector.addValidator(UIListPermissionSelector.EmptyIteratorValidator.class, new Object[0]);
        UIFormInputSet uiPermissionSet = (UIFormInputSet)this.createUIComponent(UIFormInputSet.class, "UIContainerPermission", null);
        uiPermissionSet.addChild((UIComponent)uiListPermissionSelector);
        this.addUIFormInput(uiPermissionSet);
    }

    public void setValues(UIContainer uiContainer) throws Exception {
        this.uiContainer_ = uiContainer;
        Container container = (Container)PortalDataMapper.buildModelObject((UIComponent)uiContainer);
        this.getUIStringInput("id").setReadOnly(true);
        this.invokeGetBindingBean(container);
    }

    public UIContainer getContainer() {
        return this.uiContainer_;
    }

    public UIComponent getBackComponent() {
        return this.backComponent_;
    }

    public void setBackComponent(UIComponent uiComp) {
        this.backComponent_ = uiComp;
    }

    public static class SaveActionListener
    extends EventListener<UIContainerForm> {
        public void execute(Event<UIContainerForm> event) throws Exception {
            UIContainerForm uiForm = (UIContainerForm)((Object)event.getSource());
            UIContainer uiContainer = uiForm.getContainer();
            uiForm.invokeSetBindingBean((Object)uiContainer);
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiForm.getParent();
            uiMaskWorkspace.createEvent("Close", Event.Phase.DECODE, pcontext).broadcast();
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
        }
    }
}

