/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPageCreationWizard;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIWizard;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/portal/webui/page/UIWizardPageSetInfo.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SwitchVisibleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SwitchLabelModeActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWizardPageSetInfo
extends UIForm {
    public static final String PAGE_NAME = "pageName";
    public static final String PAGE_DISPLAY_NAME = "pageDisplayName";
    public static final String VISIBLE = "visible";
    public static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    public static final String START_PUBLICATION_DATE = "startPublicationDate";
    public static final String END_PUBLICATION_DATE = "endPublicationDate";
    public static final String I18N_LABEL = "i18nizedLabel";
    private static final String LANGUAGES = "languages";
    private static final String LANGUAGES_ONCHANGE = "ChangeLanguage";
    private static final String SWITCH_MODE = "switchmode";
    private static final String SWITCH_MODE_ONCHANGE = "SwitchLabelMode";
    private boolean isEditMode = false;
    private boolean firstTime = true;
    private String selectedLocale;
    private Map<String, String> cachedLabels;

    public UIWizardPageSetInfo() throws Exception {
        UICheckBoxInput uiDateInputCheck = new UICheckBoxInput(SHOW_PUBLICATION_DATE, null, Boolean.valueOf(false));
        UICheckBoxInput uiVisibleCheck = new UICheckBoxInput(VISIBLE, null, Boolean.valueOf(false));
        UICheckBoxInput uiSwitchLabelMode = new UICheckBoxInput(SWITCH_MODE, null, Boolean.valueOf(true));
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        uiVisibleCheck.setOnChange("SwitchVisible");
        uiSwitchLabelMode.setOnChange(SWITCH_MODE_ONCHANGE);
        UIFormSelectBox uiFormLanguagesSelectBox = new UIFormSelectBox(LANGUAGES, null, null);
        this.initLanguageSelectBox(uiFormLanguagesSelectBox);
        uiFormLanguagesSelectBox.setOnChange(LANGUAGES_ONCHANGE);
        this.addChild(UIPageNodeSelector.class, null, null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_NAME, "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)uiSwitchLabelMode);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_DISPLAY_NAME, "label", null).setMaxLength(255).addValidator(StringLengthValidator.class, new Object[]{3, 120}));
        this.addUIFormInput((UIFormInput)uiFormLanguagesSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(I18N_LABEL, null, null).setMaxLength(255).addValidator(StringLengthValidator.class, new Object[]{3, 120}));
        this.addUIFormInput((UIFormInput)uiVisibleCheck.setChecked(true));
        this.addUIFormInput((UIFormInput)uiDateInputCheck);
        UIFormInputBase startPubDateInput = new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]);
        UIFormInputBase endPubDateInput = new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)startPubDateInput);
        this.addUIFormInput((UIFormInput)endPubDateInput);
        boolean isUserNav = Util.getUIPortal().getSiteType().equals((Object)SiteType.USER);
        if (isUserNav) {
            uiVisibleCheck.setRendered(false);
            uiDateInputCheck.setRendered(false);
            startPubDateInput.setRendered(false);
            endPubDateInput.setRendered(false);
        }
        this.selectedLocale = (String)this.getUIFormSelectBox(LANGUAGES).getValue();
        this.cachedLabels = new HashMap<String, String>();
        this.switchLabelMode(true);
    }

    public void setEditMode() {
        this.isEditMode = true;
        UIFormStringInput uiNameInput = (UIFormStringInput)this.getChildById(PAGE_NAME);
        uiNameInput.setReadOnly(true);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public Map<String, String> getCachedLabels() {
        return this.cachedLabels;
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        UICheckBoxInput showPubDate;
        UIFormStringInput nameTextBox = this.getUIStringInput(PAGE_NAME);
        nameTextBox.setReadOnly(true);
        super.invokeSetBindingBean(bean);
        nameTextBox.setReadOnly(false);
        UserNode node = (UserNode)bean;
        if (this.getUICheckBoxInput(SWITCH_MODE).isChecked()) {
            node.setLabel(null);
        } else if (node.getLabel() == null || node.getLabel().trim().length() == 0) {
            node.setLabel(node.getName());
        }
        Visibility visibility = this.getUICheckBoxInput(VISIBLE).isChecked() ? ((showPubDate = this.getUICheckBoxInput(SHOW_PUBLICATION_DATE)).isChecked() ? Visibility.TEMPORAL : Visibility.DISPLAYED) : Visibility.HIDDEN;
        node.setVisibility(visibility);
        Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
        long time = cal != null ? cal.getTimeInMillis() : -1L;
        node.setStartPublicationTime(time);
        cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
        time = cal != null ? cal.getTimeInMillis() : -1L;
        node.setEndPublicationTime(time);
    }

    public UserNode createUserNode(UserNode parent) throws Exception {
        UIFormStringInput nameTextBox = this.getUIStringInput(PAGE_NAME);
        String nodeName = (String)nameTextBox.getValue();
        UserNode child = parent.addChild(nodeName);
        this.invokeSetBindingBean(child);
        return child;
    }

    public void setShowCheckPublicationDate(boolean show) {
        this.getUICheckBoxInput(VISIBLE).setChecked(show);
        UICheckBoxInput uiForm = this.getUICheckBoxInput(SHOW_PUBLICATION_DATE);
        uiForm.setRendered(show);
        this.setShowPublicationDate(show && uiForm.isChecked());
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public UserNode getSelectedPageNode() {
        UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)this.getChild(UIPageNodeSelector.class);
        return uiPageNodeSelector.getSelectedNode();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.isEditMode && ((UIPageNodeSelector)this.getChild(UIPageNodeSelector.class)).getSelectedNode() == null) {
            this.reset();
        }
        super.processRender(context);
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    private void initLanguageSelectBox(UIFormSelectBox langSelectBox) {
        ArrayList<SelectItemOption> lang = new ArrayList<SelectItemOption>();
        LocaleConfigService localeService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = WebuiRequestContext.getCurrentInstance().getLocale();
        Iterator i = localeService.getLocalConfigs().iterator();
        String displayName = null;
        String language = null;
        String country = null;
        String defaultValue = null;
        while (i.hasNext()) {
            LocaleConfig config = (LocaleConfig)i.next();
            Locale locale = config.getLocale();
            language = locale.getLanguage();
            country = locale.getCountry();
            if (country != null && country.length() > 0) {
                language = language + "_" + country;
            }
            displayName = null;
            try {
                String translation;
                ResourceBundle localeResourceBundle = this.getResourceBundle(currentLocale);
                String key = "Locale." + language;
                displayName = translation = localeResourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(locale.getDisplayName(currentLocale));
            }
            catch (Exception e) {
                // empty catch block
            }
            SelectItemOption option = new SelectItemOption(displayName, (Object)language);
            if (locale.getDisplayName().equals(currentLocale.getDisplayName())) {
                option.setSelected(true);
                defaultValue = language;
            }
            lang.add(option);
        }
        Collections.sort(lang, new LanguagesComparator());
        langSelectBox.setOptions(lang);
        langSelectBox.setValue(defaultValue);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    private void switchLabelMode(boolean isExtendedMode) {
        this.getUIStringInput(PAGE_DISPLAY_NAME).setRendered(!isExtendedMode);
        this.getUIStringInput(I18N_LABEL).setRendered(isExtendedMode);
        this.getUIFormSelectBox(LANGUAGES).setRendered(isExtendedMode);
    }

    private String getLabelOnLocale(String locale) {
        return this.cachedLabels.get(locale);
    }

    public void updateCachedLabels(String locale, String label) {
        if (label != null) {
            this.cachedLabels.put(locale, label);
        }
    }

    public static class SwitchLabelModeActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            boolean isExtendedMode = uiForm.getUICheckBoxInput(UIWizardPageSetInfo.SWITCH_MODE).isChecked();
            uiForm.switchLabelMode(isExtendedMode);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class ChangeLanguageActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            UIFormSelectBox languageSelection = uiForm.getUIFormSelectBox(UIWizardPageSetInfo.LANGUAGES);
            UIFormStringInput label = uiForm.getUIStringInput(UIWizardPageSetInfo.I18N_LABEL);
            uiForm.updateCachedLabels(uiForm.selectedLocale, (String)label.getValue());
            uiForm.selectedLocale = (String)languageSelection.getValue();
            label.setValue((Object)uiForm.getLabelOnLocale(uiForm.selectedLocale));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class SwitchVisibleActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            boolean isCheck = uiForm.getUICheckBoxInput(UIWizardPageSetInfo.VISIBLE).isChecked();
            uiForm.setShowCheckPublicationDate(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class SwitchPublicationDateActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            boolean isCheck = uiForm.getUICheckBoxInput(UIWizardPageSetInfo.SHOW_PUBLICATION_DATE).isChecked();
            uiForm.getUIFormDateTimeInput(UIWizardPageSetInfo.START_PUBLICATION_DATE).setRendered(isCheck);
            uiForm.getUIFormDateTimeInput(UIWizardPageSetInfo.END_PUBLICATION_DATE).setRendered(isCheck);
            UIWizard uiWizard = (UIWizard)uiForm.getAncestorOfType(UIWizard.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIWizardPageSetInfo pageSetInfo = (UIWizardPageSetInfo)((Object)event.getSource());
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)pageSetInfo.getAncestorOfType(UIPageCreationWizard.class);
            String uri = context.getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)pageSetInfo.getChild(UIPageNodeSelector.class);
            try {
                uiPageNodeSelector.setSelectedURI(uri);
                if (!uiPageNodeSelector.getSelectedNode().getURI().equals(uri)) {
                    context.getUIApplication().addMessage(new ApplicationMessage("UIWizardPageSetInfo.msg.node.deleted", null));
                }
            }
            catch (NavigationServiceException ex) {
                context.getUIApplication().addMessage(new ApplicationMessage("UIWizardPageSetInfo.msg.navigation.deleted", null));
                uiWizard.createEvent("Abort", Event.Phase.PROCESS, context).broadcast();
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
        }
    }

    private class LanguagesComparator
    implements Comparator<SelectItemOption<String>> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption<String> o1, SelectItemOption<String> o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    }
}

