/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.proxy.ProxyFilterService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ProxyServletFilter
implements Filter {
    private ServletContext ctx;
    private static final Logger logger = LoggerFactory.getLogger(ProxyServletFilter.class);

    public void init(FilterConfig cfg) throws ServletException {
        this.ctx = cfg.getServletContext();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hresp = (HttpServletResponse)resp;
        String url = hreq.getParameter("url");
        if (url == null) {
            hresp.sendError(500, "No URL");
        } else {
            PortalContainer container = PortalContainer.getInstance((ServletContext)this.ctx);
            if (container == null) {
                hresp.sendError(500, "Could not access container for servlet context " + this.ctx.getContextPath());
            } else {
                ProxyFilterService service = (ProxyFilterService)container.getComponentInstanceOfType(ProxyFilterService.class);
                if (service == null) {
                    hresp.sendError(500, "Could not access proxy filter service " + this.ctx.getContextPath());
                } else {
                    try {
                        URI uri = URI.create(url);
                        if (!service.accept(hreq, container, uri)) {
                            hresp.sendError(403, "Gadget " + url + " is blacklisted");
                        } else {
                            chain.doFilter(req, resp);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug((Object)("Invalid URL: " + url));
                    }
                }
            }
        }
    }

    public void destroy() {
    }
}

