/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Map;
import org.exoplatform.forum.ext.activity.ActivityTask;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityType;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;

public abstract class PostActivityTask
implements ActivityTask<ForumActivityContext> {
    protected static final Log LOG = ExoLogger.getExoLogger(PostActivityTask.class);
    public static PostActivityTask ADD_POST = new PostActivityTask(){

        @Override
        public ExoSocialActivity processTitle(ExoSocialActivity activity) {
            return ForumActivityType.ADD_POST.getActivity(activity, activity.getTitle());
        }

        @Override
        protected ExoSocialActivity processComment(ForumActivityContext ctx, ExoSocialActivity comment) {
            if (ctx.getPost().getIsWaiting()) {
                comment.isHidden(true);
            }
            return this.processTitle(comment);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity topicActivity) {
            Map templateParams = topicActivity.getTemplateParams();
            templateParams.put("NumberOfReplies", "" + ctx.getTopic().getPostCount());
            return topicActivity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                Topic topic = ForumActivityUtils.getTopic(ctx);
                ctx.setTopic(topic);
                ExoSocialActivity topicActivity = ForumActivityUtils.getActivityOfTopic(ctx);
                Map templateParams = topicActivity.getTemplateParams();
                templateParams.put("NumberOfReplies", "" + topic.getPostCount());
                ActivityManager am = ForumActivityUtils.getActivityManager();
                am.updateActivity(topicActivity);
                ExoSocialActivity newComment = ForumActivityBuilder.createActivityComment(ctx.getPost(), ctx);
                newComment = this.processComment(ctx, newComment);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getPost().getOwner());
                newComment.setUserId(poster.getId());
                am.saveComment(topicActivity, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Comment for when add post " + ctx.getPost().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static PostActivityTask UPDATE_POST = new PostActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ExoSocialActivity activity) {
            return ForumActivityType.UPDATE_POST.getActivity(activity, activity.getTitle());
        }

        @Override
        protected ExoSocialActivity processComment(ForumActivityContext ctx, ExoSocialActivity comment) {
            ExoSocialActivity newComment = ForumActivityBuilder.createActivityComment(ctx.getPost(), ctx);
            if (comment != null) {
                comment.setTitle(newComment.getTitle());
                comment.setTitleId(newComment.getTitleId());
                comment.setTemplateParams(newComment.getTemplateParams());
                comment = this.processTitle(comment);
            } else {
                comment = newComment;
                comment = this.processTitle(comment);
            }
            return comment;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity topicActivity) {
            return topicActivity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                Topic topic = ForumActivityUtils.getTopic(ctx);
                ctx.setTopic(topic);
                ExoSocialActivity topicActivity = ForumActivityUtils.getActivityOfTopic(ctx);
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity comment = ForumActivityUtils.getCommentOfPost(ctx);
                boolean isCommentExist = false;
                if (comment != null) {
                    isCommentExist = true;
                }
                comment = this.processComment(ctx, comment);
                if (isCommentExist) {
                    am.updateActivity(comment);
                } else {
                    Identity poster = ForumActivityUtils.getIdentity(ctx.getPost().getOwner());
                    comment.setUserId(poster.getId());
                    am.saveComment(topicActivity, comment);
                }
                return comment;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Comment when updates post " + ctx.getPost().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static PostActivityTask HIDE_POST = new PostActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity topicActivity) {
            return topicActivity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                String postActivityId = ForumActivityUtils.getForumService().getActivityIdForOwnerPath(ctx.getPost().getPath());
                ExoSocialActivity postActivity = null;
                if (postActivityId != null && (postActivity = am.getActivity(postActivityId)) != null) {
                    postActivity.isHidden(true);
                    am.updateActivity(postActivity);
                }
                return postActivity;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not hide comment when hide post " + ctx.getPost().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static PostActivityTask UNHIDE_POST = new PostActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity topicActivity) {
            return topicActivity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                String postActivityId = ForumActivityUtils.getForumService().getActivityIdForOwnerPath(ctx.getPost().getPath());
                ExoSocialActivity postActivity = null;
                if (postActivityId != null && (postActivity = am.getActivity(postActivityId)) != null) {
                    postActivity.isHidden(false);
                    am.updateActivity(postActivity);
                }
                return postActivity;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not unhide comment when unhide post " + ctx.getPost().getId()), (Throwable)e);
                return null;
            }
        }
    };

    @Override
    public void start(ForumActivityContext ctx) {
    }

    @Override
    public void end(ForumActivityContext ctx) {
    }

    protected abstract ExoSocialActivity processTitle(ExoSocialActivity var1);

    protected abstract ExoSocialActivity processActivity(ForumActivityContext var1, ExoSocialActivity var2);

    protected ExoSocialActivity processComment(ForumActivityContext ctx, ExoSocialActivity comment) {
        return this.processTitle(comment);
    }
}

