/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.resolver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TitleResolver {
    private static final Log log = ExoLogger.getLogger(TitleResolver.class);

    public static String getId(String title, boolean isEncoded) {
        String id;
        block4: {
            if (title == null) {
                return null;
            }
            id = title;
            if (isEncoded) {
                try {
                    id = URLDecoder.decode(title, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)String.format("Getting Page Id from %s failed because of UnspportedEncodingException. Using page title(%s) instead (Not recommended. Fix it if possible!!!)", title), (Throwable)e1);
                }
            }
        }
        return TitleResolver.replaceSpacebyUnderscore(id);
    }

    private static String replaceSpacebyUnderscore(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", false);
        StringBuilder sb = new StringBuilder();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
        }
        while (st.hasMoreElements()) {
            sb.append("_").append(st.nextElement());
        }
        return sb.toString();
    }
}

