/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.jcr.config.PropertiesParser;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.SystemParametersPersistenceConfigurator;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemParameterUpdater {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SystemParameterUpdater");
    private WorkspaceInitializer workspaceInitializer;
    private List<SimpleParameterEntry> parameters;
    private PropertiesParser propertiesParser;
    private Set<String> updatedParameterNames = new HashSet<String>();
    private Set<String> unmodifiableParameters = new HashSet<String>();
    private Set<String> beforeInitializeParameters = new HashSet<String>();
    private Map<String, Exception> parametersToValidate = new HashMap<String, Exception>();
    private Map<String, String> oldParameters;
    private Map<String, String> systemProperties;
    private SystemParametersPersistenceConfigurator sppc;

    public SystemParameterUpdater(List<SimpleParameterEntry> parameters, SystemParametersPersistenceConfigurator sppc, String componentName, WorkspaceEntry workspaceEntry) {
        this.parameters = parameters;
        this.unmodifiableParameters = sppc.getUnmodifiableParametersForWorkspaceComponent(componentName);
        this.beforeInitializeParameters = sppc.getBeforeInitializeParametersForWorkspaceComponent(componentName);
        this.oldParameters = sppc.getOldParameters();
        this.systemProperties = sppc.getSystemProperties();
        this.propertiesParser = new PropertiesParser(workspaceEntry, componentName);
        this.sppc = sppc;
    }

    public void updateParameter(String parameterName) {
        if (this.updatedParameterNames.contains(parameterName)) {
            return;
        }
        this.updateForcedParameterIfNeeded(parameterName, this.getAlreadySetParameter(parameterName));
        this.updateDefaultParameterIfNeeded(parameterName, this.getAlreadySetParameter(parameterName));
    }

    private void updateForcedParameterIfNeeded(String parameterName, SimpleParameterEntry alreadySetParameter) {
        String actualForcedParameterValue = this.propertiesParser.getForcedParameterValue(parameterName, this.systemProperties);
        String previousForcedParameterValue = this.propertiesParser.getForcedParameterValue(parameterName, this.oldParameters);
        if (actualForcedParameterValue != null) {
            if (alreadySetParameter != null && actualForcedParameterValue.equals(alreadySetParameter.getValue())) {
                return;
            }
            if (!actualForcedParameterValue.equals(previousForcedParameterValue) && !this.isAllowedToOverride(parameterName)) {
                return;
            }
            if (alreadySetParameter != null) {
                alreadySetParameter.setValue(actualForcedParameterValue);
            } else {
                this.parameters.add(new SimpleParameterEntry(parameterName, actualForcedParameterValue));
            }
            this.updatedParameterNames.add(parameterName);
            return;
        }
    }

    private void updateDefaultParameterIfNeeded(String parameterName, SimpleParameterEntry alreadySetParameter) {
        String actualDefaultParameterValue = this.propertiesParser.getDefaultParameterValue(parameterName, this.systemProperties);
        String previousDefaultParameterValue = this.propertiesParser.getDefaultParameterValue(parameterName, this.oldParameters);
        if (actualDefaultParameterValue != null && alreadySetParameter == null) {
            if (!actualDefaultParameterValue.equals(previousDefaultParameterValue) && !this.isAllowedToOverride(parameterName)) {
                return;
            }
            this.parameters.add(new SimpleParameterEntry(parameterName, actualDefaultParameterValue));
            this.updatedParameterNames.add(parameterName);
            return;
        }
    }

    private SimpleParameterEntry getAlreadySetParameter(String parameterName) {
        for (SimpleParameterEntry parameterEntry : this.parameters) {
            if (!parameterEntry.getName().equals(parameterName)) continue;
            return parameterEntry;
        }
        return null;
    }

    public void unupdateParameter(String parameterName) {
        this.updatedParameterNames.remove(parameterName);
    }

    public void updateSystemParameters() {
        this.updatedParameterNames.clear();
        for (String parameterName : this.propertiesParser.getParameterNames(this.systemProperties.keySet())) {
            this.updateParameter(parameterName);
        }
    }

    public void setParameters(List<SimpleParameterEntry> parameters) {
        this.parameters = parameters;
        this.updatedParameterNames.clear();
        this.updateSystemParameters();
    }

    public boolean isAlreadyUpdated(String parameterName) {
        return this.updatedParameterNames.contains(parameterName);
    }

    public boolean isAllowedToOverride(String parameterName) {
        if (this.unmodifiableParameters.contains(parameterName)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Parameter " + parameterName + " is not overridden because it is set to 'unmodifiable' via system properties in the " + SystemParametersPersistenceConfigurator.class.getSimpleName()));
            }
            return false;
        }
        if (this.beforeInitializeParameters.contains(parameterName)) {
            if (this.workspaceInitializer == null) {
                this.parametersToValidate.put(parameterName, new Exception());
                return true;
            }
            if (this.workspaceInitializer.isWorkspaceInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Parameter " + parameterName + " is not overridden because workspace is already initialized and parameter is set to 'before-initialize'" + " via system properties in the " + SystemParametersPersistenceConfigurator.class.getSimpleName()));
                }
                return false;
            }
        }
        return true;
    }

    public void setWorkspaceInitializer(WorkspaceInitializer workspaceInitializer) {
        this.workspaceInitializer = workspaceInitializer;
    }

    public void validateOverriddenParameters() {
        for (Map.Entry<String, Exception> mapEntry : this.parametersToValidate.entrySet()) {
            this.parametersToValidate.remove(mapEntry.getKey());
            if (!this.workspaceInitializer.isWorkspaceInitialized()) continue;
            this.sppc.rollback();
            throw new IllegalStateException("Unable to override parameter '" + mapEntry.getKey() + "' set in system property because this operation is allowed only for non initialized workspaces", mapEntry.getValue());
        }
    }

    public int getUpdatedParametersAmount() {
        return this.updatedParameterNames.size();
    }
}

