/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2CleaningScipts
extends DBCleaningScripts {
    public DB2CleaningScipts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        super(dialect, rEntry);
        this.prepareDroppingTablesApproachScripts();
    }

    public DB2CleaningScipts(String dialect, WorkspaceEntry wEntry) throws DBCleanException {
        super(dialect, wEntry);
        if (this.multiDb) {
            this.prepareDroppingTablesApproachScripts();
        } else {
            this.prepareSimpleCleaningApproachScripts();
        }
    }

    @Override
    protected Collection<String> getFKRemovingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROP";
        scripts.add("ALTER TABLE " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.itemTableSuffix + "_PAREN";
        scripts.add("ALTER TABLE " + this.itemTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.valueTableSuffix;
        scripts.add("ALTER TABLE " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.itemTableSuffix;
        scripts.add("ALTER TABLE " + this.itemTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.refTableSuffix;
        scripts.add("ALTER TABLE " + this.refTableName + " DROP CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getFKAddingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_PK_" + this.valueTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.itemTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.refTableSuffix + " PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)";
        scripts.add("ALTER TABLE " + this.refTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROP FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.itemTableSuffix + "_PAREN FOREIGN KEY(PARENT_ID) REFERENCES " + this.itemTableName + "(ID)";
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM");
        scripts.add("DROP INDEX JCR_IDX_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("DROP INDEX JCR_IDX_" + this.refTableSuffix + "_PROPERTY");
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesAddingScripts() throws DBCleanException {
        ArrayList<String> scripts = new ArrayList<String>();
        try {
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.valueTableSuffix + "_PROPERTY ON " + this.valueTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.refTableSuffix + "_PROPERTY ON " + this.refTableName, this.multiDb, this.dialect, this.wsEntry));
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        catch (IOException e) {
            throw new DBCleanException(e);
        }
        return scripts;
    }

    @Override
    protected void prepareSimpleCleaningApproachScripts() {
        super.prepareSimpleCleaningApproachScripts();
        this.rollbackingScripts.clear();
    }
}

