/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.Serializable;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public abstract class AbstractValidator
implements Validator,
Serializable {
    protected boolean exceptionOnMissingMandatory = false;
    protected boolean trimValue = false;

    protected String getLabelFor(UIFormInput uiInput) throws Exception {
        int index;
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        String label = uiInput.getName();
        if (uiForm != null) {
            label = uiForm.getLabel(label);
        }
        if ((index = (label = label.trim()).indexOf(58)) != -1) {
            label = label.substring(0, index);
        }
        return label.trim();
    }

    @Override
    public void validate(UIFormInput uiInput) throws Exception {
        String value = this.trimmedValueOrNullIfBypassed((String)uiInput.getValue(), uiInput, this.exceptionOnMissingMandatory, this.trimValue);
        if (value == null) {
            return;
        }
        if (!this.isValid(value, uiInput)) {
            throw this.createMessageException(value, uiInput);
        }
    }

    protected MessageException createMessageException(String value, UIFormInput uiInput) throws Exception {
        return this.createMessageException(value, uiInput, this.getMessageLocalizationKey());
    }

    protected MessageException createMessageException(String value, UIFormInput uiInput, String localizationKey) throws Exception {
        return new MessageException(new ApplicationMessage(localizationKey, this.getMessageArgs(value, uiInput), 1));
    }

    protected Object[] getMessageArgs(String value, UIFormInput uiInput) throws Exception {
        return new Object[]{this.getLabelFor(uiInput)};
    }

    protected abstract String getMessageLocalizationKey();

    protected abstract boolean isValid(String var1, UIFormInput var2);

    protected String trimmedValueOrNullIfBypassed(String value, UIFormInput uiInput, boolean exceptionOnMissingMandatory, boolean trimValue) throws Exception {
        if (value != null) {
            String tmp = value.trim();
            if (trimValue) {
                value = tmp;
            }
            String string = value = tmp.isEmpty() ? null : value;
        }
        if (exceptionOnMissingMandatory && value == null) {
            throw this.createMessageException(value, uiInput, "EmptyFieldValidator.msg.empty-input");
        }
        return value;
    }
}

