/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class PropertyChangeSupport
implements Serializable {
    static final long serialVersionUID = 0L;
    PropertyChangeEvent[] changeEvents = new PropertyChangeEvent[0];
    private Object source;
    private final Object lock = new Object();

    public PropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void addPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.addPropertyChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            PropertyChangeEvent[] results = new PropertyChangeEvent[this.changeEvents.length + 1];
            for (int i = 0; i < this.changeEvents.length; ++i) {
                results[i] = this.changeEvents[i];
            }
            results[this.changeEvents.length] = evt;
            this.changeEvents = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePropertyChange(String propertyName) {
        if (this.hasPropertyName(propertyName)) {
            Object object = this.lock;
            synchronized (object) {
                PropertyChangeEvent[] results = new PropertyChangeEvent[this.changeEvents.length - 1];
                int j = 0;
                for (int i = 0; i < this.changeEvents.length; ++i) {
                    if (this.changeEvents[i].getPropertyName().equals(propertyName)) continue;
                    results[j++] = this.changeEvents[i];
                }
                this.changeEvents = results;
            }
            return true;
        }
        return false;
    }

    public PropertyChangeEvent[] getChangeEvents() {
        return this.changeEvents;
    }

    public PropertyChangeEvent getPropertyChange(String propertyName) {
        for (int i = 0; i < this.changeEvents.length; ++i) {
            if (!this.changeEvents[i].getPropertyName().equals(propertyName)) continue;
            return this.changeEvents[i];
        }
        return null;
    }

    public boolean hasPropertyName(String propertyName) {
        for (int i = 0; i < this.changeEvents.length; ++i) {
            if (!this.changeEvents[i].getPropertyName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }
}

