/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.EcmsSearchResult;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class BaseSearchServiceConnector
extends SearchServiceConnector {
    public static final String sortByDate = "date";
    public static final String sortByRelevancy = "relevancy";
    public static final String sortByTitle = "title";
    protected SiteSearchService siteSearch_ = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
    protected ManageDriveService driveService_ = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
    protected static final Log LOG = ExoLogger.getLogger((String)BaseSearchServiceConnector.class.getName());
    public static final String DEFAULT_SITENAME = "intranet";
    public static final String PAGE_NAGVIGATION = "documents";
    public static final String NONE_NAGVIGATION = "#";
    public static final String PORTLET_NAME = "FileExplorerPortlet";

    public BaseSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        List<SearchResult> ret;
        block3: {
            ret = new ArrayList<SearchResult>();
            if (query != null) {
                query = query.trim();
            }
            QueryCriteria criteria = this.createQueryCriteria(query, offset, limit, sort, order);
            try {
                criteria.setSiteName(this.getSitesStr(sites));
                ret = this.convertResult(this.searchNodes(criteria), limit, context);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e);
            }
        }
        return ret;
    }

    private String getSitesStr(Collection<String> sites) {
        if (sites == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (String site : sites) {
            s.append(site).append(',');
        }
        return s.substring(0, s.length() - 1);
    }

    protected abstract QueryCriteria createQueryCriteria(String var1, long var2, long var4, String var6, String var7);

    protected abstract AbstractPageList<ResultNode> searchNodes(QueryCriteria var1) throws Exception;

    protected abstract ResultNode filterNode(ResultNode var1) throws RepositoryException;

    protected List<SearchResult> convertResult(AbstractPageList<ResultNode> pageList, int limit, SearchContext context) {
        ArrayList<SearchResult> ret;
        block8: {
            ret = new ArrayList<SearchResult>();
            try {
                if (pageList != null) {
                    for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
                        for (ResultNode obj : pageList.getPage(i)) {
                            try {
                                ResultNode retNode;
                                if (!(obj instanceof ResultNode) || (retNode = this.filterNode(obj)) == null) continue;
                                DriveData driveData = this.getDriveData(retNode);
                                Calendar date = this.getDate(retNode);
                                EcmsSearchResult result = new EcmsSearchResult(this.getPath(driveData, retNode, context), this.getTitleResult(retNode), retNode.getExcerpt(), this.getDetails(retNode, context), this.getImageUrl(retNode), date.getTimeInMillis(), (long)retNode.getScore(), this.getFileType(retNode));
                                if (result != null) {
                                    ret.add(result);
                                }
                                if (ret.size() < limit) continue;
                                return ret;
                            }
                            catch (Exception e) {
                                if (!LOG.isErrorEnabled()) continue;
                                LOG.error((Object)e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)e.getMessage());
            }
        }
        return ret;
    }

    protected String fileSize(Node node) throws Exception {
        return Utils.fileSize((Node)node);
    }

    protected DriveData getDriveData(Node node) throws Exception {
        List<DriveData> dataList = this.getDriveDataList();
        DriveData ret = null;
        for (DriveData data : dataList) {
            if (!node.getPath().startsWith(data.getHomePath()) || ret != null && ret.getHomePath().length() >= data.getHomePath().length()) continue;
            ret = data;
        }
        return ret;
    }

    protected List<DriveData> getDriveDataList() throws Exception {
        String user = ConversationState.getCurrent().getIdentity().getUserId();
        List memberships = IdentityConstants.ANONIM.equals(user) ? new ArrayList() : Utils.getMemberships();
        return this.driveService_.getDriveByUserRoles(user, memberships);
    }

    protected Calendar getDate(Node node) throws Exception {
        return node.hasProperty("exo:lastModifiedDate") ? node.getProperty("exo:lastModifiedDate").getDate() : node.getProperty("exo:dateCreated").getDate();
    }

    protected String formatDate(Calendar date) {
        DateFormat format = SimpleDateFormat.getDateTimeInstance(0, 3);
        return " - " + format.format(date.getTime());
    }

    protected String getDriveTitle(DriveData driveData) {
        if (driveData == null) {
            return "";
        }
        String id = driveData.getName();
        String path = driveData.getHomePath();
        try {
            Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
            Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
            Object space = spaceServiceClass.getDeclaredMethod("getSpaceByGroupId", String.class).invoke(spaceService, id.replace(".", "/"));
            if (space != null) {
                return String.valueOf(spaceClass.getDeclaredMethod("getDisplayName", new Class[0]).invoke(space, new Object[0]));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repoService.getCurrentRepository()).getItem(path);
            while (groupNode.getParent() != null) {
                if (groupNode.hasProperty("exo:driveLabel")) {
                    return groupNode.getProperty("exo:driveLabel").getString();
                }
                groupNode = groupNode.getParent();
            }
            return id.replace(".", " / ");
        }
        catch (Exception e) {
            return id.replace(".", " / ");
        }
    }

    protected abstract String getPath(DriveData var1, ResultNode var2, SearchContext var3) throws Exception;

    protected abstract String getFileType(ResultNode var1) throws Exception;

    protected abstract String getTitleResult(ResultNode var1) throws Exception;

    protected abstract String getImageUrl(Node var1);

    protected abstract String getDetails(ResultNode var1, SearchContext var2) throws Exception;
}

