/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.ext.action;

import org.exoplatform.services.command.action.ActionMatcher;
import org.exoplatform.services.command.action.Condition;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;

public class SessionEventMatcher
implements ActionMatcher {
    public static final String EVENTTYPE_KEY = "types";
    public static final String WORKSPACE_KEY = "workspaces";
    public static final String PATH_KEY = "paths";
    public static final String NODETYPES_KEY = "nodeTypes";
    private final int eventTypes;
    private final String[] workspaces;
    private final QPath[] paths;
    private boolean isDeep;
    private final InternalQName[] nodeTypeNames;
    private final NodeTypeDataManager typeDataManager;

    public SessionEventMatcher(int eventTypes, QPath[] paths, boolean isDeep, String[] workspaces, InternalQName[] nodeTypeNames, NodeTypeDataManager typeDataManager) {
        this.eventTypes = eventTypes;
        this.paths = paths;
        this.isDeep = isDeep;
        this.nodeTypeNames = nodeTypeNames;
        this.workspaces = workspaces;
        this.typeDataManager = typeDataManager;
    }

    public String dump() {
        StringBuilder str = new StringBuilder("SessionEventMatcher: ").append(this.eventTypes).append("\n");
        if (this.paths != null) {
            str.append("Paths (isDeep=").append(this.isDeep).append("):\n");
            for (QPath qPath : this.paths) {
                str.append(qPath.getAsString()).append("\n");
            }
        }
        if (this.nodeTypeNames != null) {
            str.append("Node Types:\n");
            for (InternalQName internalQName : this.nodeTypeNames) {
                str.append(internalQName.getAsString()).append("\n");
            }
        }
        return str.toString();
    }

    public final boolean match(Condition conditions) {
        if (conditions.get((Object)EVENTTYPE_KEY) == null || !this.isEventTypeMatch((Integer)conditions.get((Object)EVENTTYPE_KEY))) {
            return false;
        }
        if (!this.isPathMatch((QPath)conditions.get((Object)PATH_KEY))) {
            return false;
        }
        if (this.nodeTypeNames != null && !this.isNodeTypesMatch((InternalQName[])conditions.get((Object)NODETYPES_KEY))) {
            return false;
        }
        if (!this.isWorkspaceMatch((String)conditions.get((Object)WORKSPACE_KEY))) {
            return false;
        }
        return this.internalMatch(conditions);
    }

    private boolean isEventTypeMatch(int type) {
        return (this.eventTypes & type) > 0;
    }

    private boolean isNodeTypesMatch(InternalQName[] nodeTypes) {
        if (this.nodeTypeNames == null || nodeTypes == null) {
            return true;
        }
        for (InternalQName nt : this.nodeTypeNames) {
            if (!this.typeDataManager.isNodeType(nt, nodeTypes)) continue;
            return true;
        }
        return false;
    }

    private boolean isPathMatch(QPath itemPath) {
        if (this.paths == null || itemPath == null) {
            return true;
        }
        for (QPath p : this.paths) {
            if (!itemPath.equals(p) && !itemPath.isDescendantOf(p, !this.isDeep)) continue;
            return true;
        }
        return false;
    }

    private boolean isWorkspaceMatch(String workspace) {
        if (this.workspaces == null || workspace == null) {
            return true;
        }
        for (String ws : this.workspaces) {
            if (!ws.equals(workspace)) continue;
            return true;
        }
        return false;
    }

    protected boolean internalMatch(Condition conditions) {
        return true;
    }
}

