/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class DB2ConnectionFactory
extends GenericCQConnectionFactory {
    public DB2ConnectionFactory(DataSource dataSource, JDBCDataContainerConfig containerConfig) {
        super(dataSource, containerConfig);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new DB2MultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new DB2SingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isIDNeededForPaging() {
        return false;
    }

    public boolean isReindexingSupport() {
        return true;
    }
}

