/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapperImpl;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.EditBox;
import com.coremedia.iso.boxes.EditListBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.HintMediaHeaderBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.NullMediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultMp4Builder
implements Mp4Builder {
    Set<StaticChunkOffsetBox> chunkOffsetBoxes = new HashSet<StaticChunkOffsetBox>();
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class.getName());

    public IsoFile build(Movie movie) throws IOException {
        LOG.info("Creating movie " + movie);
        IsoFile isoFile = new IsoFile(new IsoBufferWrapperImpl(new byte[0]));
        isoFile.parse();
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("iso2");
        minorBrands.add("avc1");
        isoFile.addBox(new FileTypeBox("isom", 0L, minorBrands));
        isoFile.addBox(this.createMovieBox(movie));
        InterleaveChunkMdat mdat = new InterleaveChunkMdat(movie);
        isoFile.addBox(mdat);
        long dataOffset = mdat.calculateOffset() + 8L;
        for (StaticChunkOffsetBox chunkOffsetBox : this.chunkOffsetBoxes) {
            long[] offsets = chunkOffsetBox.getChunkOffsets();
            int i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + dataOffset;
            }
        }
        return isoFile;
    }

    private MovieBox createMovieBox(Movie movie) {
        MovieBox movieBox = new MovieBox();
        LinkedList<Box> movieBoxChildren = new LinkedList<Box>();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(DateHelper.convert(new Date()));
        mvhd.setModificationTime(DateHelper.convert(new Date()));
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = this.getDuration(track) * movieTimeScale / track.getTrackMetaData().getTimescale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        movieBoxChildren.add(mvhd);
        for (Track track : movie.getTracks()) {
            if (track.getType() == Track.Type.UNKNOWN) continue;
            movieBoxChildren.add(this.createTrackBox(track, movie));
        }
        movieBox.setBoxes(movieBoxChildren);
        return movieBox;
    }

    private TrackBox createTrackBox(Track track, Movie movie) {
        LOG.info("Creating Mp4TrackImpl " + track);
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        int flags = 0;
        if (track.isEnabled()) {
            ++flags;
        }
        if (track.isInMovie()) {
            flags += 2;
        }
        if (track.isInPreview()) {
            flags += 4;
        }
        if (track.isInPoster()) {
            flags += 8;
        }
        tkhd.setFlags(flags);
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        tkhd.setDuration(this.getDuration(track) * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(DateHelper.convert(new Date()));
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        trackBox.addBox(tkhd);
        EditBox edit = new EditBox();
        EditListBox editListBox = new EditListBox();
        editListBox.setEntries(Collections.singletonList(new EditListBox.Entry(editListBox, (long)(track.getTrackMetaData().getStartTime() * (double)this.getTimescale(movie)), -1L, 1.0)));
        edit.addBox(editListBox);
        trackBox.addBox(edit);
        MediaBox mdia = new MediaBox();
        trackBox.addBox(mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        mdhd.setDuration(this.getDuration(track));
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        mdia.addBox(mdhd);
        HandlerBox hdlr = new HandlerBox();
        mdia.addBox(hdlr);
        switch (track.getType()) {
            case VIDEO: {
                hdlr.setHandlerType("vide");
                break;
            }
            case SOUND: {
                hdlr.setHandlerType("soun");
                break;
            }
            case HINT: {
                hdlr.setHandlerType("hint");
                break;
            }
            case TEXT: {
                hdlr.setHandlerType("text");
                break;
            }
            default: {
                throw new RuntimeException("Dont know handler type " + (Object)((Object)track.getType()));
            }
        }
        MediaInformationBox minf = new MediaInformationBox();
        switch (track.getType()) {
            case VIDEO: {
                VideoMediaHeaderBox vmhd = new VideoMediaHeaderBox();
                minf.addBox(vmhd);
                break;
            }
            case SOUND: {
                SoundMediaHeaderBox smhd = new SoundMediaHeaderBox();
                minf.addBox(smhd);
                break;
            }
            case HINT: {
                HintMediaHeaderBox hmhd = new HintMediaHeaderBox();
                minf.addBox(hmhd);
                break;
            }
            case TEXT: 
            case NULL: {
                NullMediaHeaderBox nmhd = new NullMediaHeaderBox();
                minf.addBox(nmhd);
            }
        }
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        minf.addBox(dinf);
        SampleTableBox stbl = new SampleTableBox();
        stbl.addBox(track.getSampleDescriptionBox());
        if (track.getDecodingTimeEntries() != null && !track.getDecodingTimeEntries().isEmpty()) {
            TimeToSampleBox stts = new TimeToSampleBox();
            stts.setEntries(track.getDecodingTimeEntries());
            stbl.addBox(stts);
        }
        if (track.getCompositionTimeEntries() != null && !track.getCompositionTimeEntries().isEmpty()) {
            CompositionTimeToSample ctts = new CompositionTimeToSample();
            ctts.setEntries(track.getCompositionTimeEntries());
            stbl.addBox(ctts);
        }
        if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(track.getSyncSamples());
            stbl.addBox(stss);
        }
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            SampleDependencyTypeBox sdtp = new SampleDependencyTypeBox();
            sdtp.setEntries(track.getSampleDependencies());
            stbl.addBox(sdtp);
        }
        long[] chunkSize = DefaultMp4Builder.getChunkSizes(track, movie);
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        long lastChunkSize = Integer.MIN_VALUE;
        for (int i = 0; i < chunkSize.length; ++i) {
            if (lastChunkSize == chunkSize[i]) continue;
            stsc.getEntries().add(new SampleToChunkBox.Entry(i + 1, chunkSize[i], 1L));
            lastChunkSize = chunkSize[i];
        }
        stbl.addBox(stsc);
        SampleSizeBox stsz = new SampleSizeBox();
        long[] sizes = new long[track.getSamples().size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = track.getSamples().get(i).size();
        }
        stsz.setSampleSizes(sizes);
        stbl.addBox(stsz);
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        this.chunkOffsetBoxes.add(stco);
        long offset = 0L;
        long[] chunkOffset = new long[chunkSize.length];
        LOG.fine("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId());
        for (int i = 0; i < chunkSize.length; ++i) {
            LOG.finer("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId() + " chunk " + i);
            for (Track current : movie.getTracks()) {
                LOG.finest("Adding offsets of track_" + current.getTrackMetaData().getTrackId());
                long[] chunkSizes = DefaultMp4Builder.getChunkSizes(current, movie);
                long firstSampleOfChunk = 0L;
                for (int j = 0; j < i; ++j) {
                    firstSampleOfChunk += chunkSizes[j];
                }
                if (current == track) {
                    chunkOffset[i] = offset;
                }
                for (long j = firstSampleOfChunk; j < firstSampleOfChunk + chunkSizes[i]; ++j) {
                    if (j > Integer.MAX_VALUE) {
                        throw new InternalError("I cannot deal with a number of samples > Integer.MAX_VALUE");
                    }
                    offset += current.getSamples().get((int)j).size();
                }
            }
        }
        stco.setChunkOffsets(chunkOffset);
        stbl.addBox(stco);
        minf.addBox(stbl);
        mdia.addBox(minf);
        return trackBox;
    }

    static long[] getChunkSizes(Track track, Movie movie) {
        Track referenceTrack = null;
        long[] referenceChunkStarts = null;
        long referenceSampleCount = 0L;
        for (Track test : movie.getTracks()) {
            if (test.getSyncSamples() == null || test.getSyncSamples().length <= 0) continue;
            referenceTrack = test;
            referenceChunkStarts = test.getSyncSamples();
            referenceSampleCount = test.getSamples().size();
        }
        if (referenceTrack == null) {
            throw new RuntimeException("need some sync samples");
        }
        long[] chunkSizes = new long[referenceTrack.getSyncSamples().length];
        long sc = track.getSamples().size();
        double stretch = (double)sc / (double)referenceSampleCount;
        for (int i = 0; i < chunkSizes.length; ++i) {
            long start = Math.round(stretch * (double)(referenceChunkStarts[i] - 1L));
            long end = 0L;
            end = referenceChunkStarts.length == i + 1 ? Math.round(stretch * (double)referenceSampleCount) : Math.round(stretch * (double)(referenceChunkStarts[i + 1] - 1L));
            chunkSizes[i] = end - start;
        }
        assert ((long)track.getSamples().size() == DefaultMp4Builder.sum(chunkSizes)) : "The number of samples and the sum of all chunk lengths must be equal";
        return chunkSizes;
    }

    private static long sum(long[] ls) {
        long rc = 0L;
        for (long l : ls) {
            rc += l;
        }
        return rc;
    }

    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    public long getTimescale(Movie movie) {
        long timescale = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            timescale = DefaultMp4Builder.gcd(track.getTrackMetaData().getTimescale(), timescale);
        }
        return timescale;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return DefaultMp4Builder.gcd(b, a % b);
    }

    private static class InterleaveChunkMdat
    extends AbstractBox {
        List<Track> tracks;
        Map<Track, long[]> chunks = new HashMap<Track, long[]>();

        private InterleaveChunkMdat(Movie movie) {
            super(IsoFile.fourCCtoBytes("mdat"));
            this.tracks = movie.getTracks();
            for (Track track : movie.getTracks()) {
                this.chunks.put(track, DefaultMp4Builder.getChunkSizes(track, movie));
            }
        }

        protected long getContentSize() {
            long size = 0L;
            for (Track track : this.tracks) {
                for (IsoBufferWrapper sample : track.getSamples()) {
                    size += sample.size();
                }
            }
            return size;
        }

        public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
            throw new InternalError("This box cannot be created by parsing");
        }

        protected void getContent(IsoOutputStream os) throws IOException {
            long aaa = 0L;
            for (int i = 0; i < this.chunks.values().iterator().next().length; ++i) {
                for (Track track : this.tracks) {
                    long[] chunkSizes = this.chunks.get(track);
                    long firstSampleOfChunk = 0L;
                    for (int j = 0; j < i; ++j) {
                        firstSampleOfChunk += chunkSizes[j];
                    }
                    for (long j = firstSampleOfChunk; j < firstSampleOfChunk + chunkSizes[i]; ++j) {
                        if (j > Integer.MAX_VALUE) {
                            throw new InternalError("I cannot deal with a number of samples > Integer.MAX_VALUE");
                        }
                        IsoBufferWrapper ibw = track.getSamples().get((int)j);
                        while (ibw.remaining() >= 1024L) {
                            os.write(ibw.read(1024));
                        }
                        while (ibw.remaining() > 0L) {
                            os.write(ibw.readByte());
                        }
                    }
                }
            }
            System.err.println(aaa);
        }
    }
}

