/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.thread;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SocialExecutorService<T> {
    private final int DEFAULT_THREAD_NUMBER = 30;
    private ExecutorService executor;
    Map<String, Future<T>> futureCollections = new HashMap<String, Future<T>>();
    private String lastId = "";
    private static final Log LOG = ExoLogger.getLogger(SocialExecutorService.class);

    public SocialExecutorService(int threadConfigNumber) {
        this.executor = threadConfigNumber > 0 ? Executors.newFixedThreadPool(threadConfigNumber) : Executors.newFixedThreadPool(30);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public T submit(Callable<T> task, String id) {
        try {
            this.futureCollections.put(id, this.executor.submit(task));
            this.lastId = id;
        }
        catch (Exception e) {
            LOG.warn((Object)("Execution task fail." + e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    LOG.warn((Object)"Pool did not terminate");
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not shutdown executor." + e));
        }
        finally {
            this.futureCollections = null;
            this.executor = null;
        }
    }

    public Map<String, Future<T>> getFutureCollections() {
        try {
            Future<T> ft = this.futureCollections.get(this.lastId);
            if (ft.get() != null) {
                HashMap<String, Future<T>> result = new HashMap<String, Future<T>>(this.futureCollections);
                this.futureCollections.clear();
                return result;
            }
        }
        catch (NullPointerException e) {
            return Collections.emptyMap();
        }
        catch (Exception e) {
            LOG.warn((Object)("Gets Future Collections fail. " + e));
        }
        return Collections.emptyMap();
    }
}

