/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.util.Library;

public class PageTree
extends Dictionary {
    private int kidsCount = 0;
    private Vector kidsReferences;
    private Vector kidsPageAndPages;
    private PageTree parent;
    private boolean inited;
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private Resources resources;
    private boolean loadedResources;
    protected float rotationFactor = 0.0f;
    protected boolean isRotationFactor = false;

    public PageTree(Library l, Hashtable h) {
        super(l, h);
    }

    protected synchronized void dispose(boolean cache) {
        boolean disposeSuccess;
        if (this.kidsReferences != null && !cache) {
            this.kidsReferences.clear();
            this.kidsReferences.trimToSize();
        }
        if (this.kidsPageAndPages != null) {
            for (Object pageOrPages : this.kidsPageAndPages) {
                if (pageOrPages instanceof Page) {
                    ((Page)pageOrPages).dispose(cache);
                    continue;
                }
                if (!(pageOrPages instanceof PageTree)) continue;
                ((PageTree)pageOrPages).dispose(cache);
            }
            if (!cache) {
                this.kidsPageAndPages.clear();
                this.kidsPageAndPages.trimToSize();
            }
        }
        if (this.resources != null && (disposeSuccess = this.resources.dispose(cache, this))) {
            this.loadedResources = false;
        }
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Object parentTree = this.library.getObject(this.entries, "Parent");
        if (parentTree instanceof PageTree) {
            this.parent = (PageTree)this.library.getObject(this.entries, "Parent");
        }
        this.kidsCount = this.library.getNumber(this.entries, "Count").intValue();
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "MediaBox");
        if (boxDimensions != null) {
            this.mediaBox = new PRectangle(boxDimensions);
        }
        if ((boxDimensions = (Vector)this.library.getObject(this.entries, "CropBox")) != null) {
            this.cropBox = new PRectangle(boxDimensions);
        }
        this.kidsReferences = (Vector)this.library.getObject(this.entries, "Kids");
        this.kidsPageAndPages = new Vector(this.kidsReferences.size());
        this.kidsPageAndPages.setSize(this.kidsReferences.size());
        Object tmpRotation = this.library.getObject(this.entries, "Rotate");
        if (tmpRotation != null) {
            this.rotationFactor = ((Number)tmpRotation).floatValue();
            this.isRotationFactor = true;
        }
        this.inited = true;
    }

    void initRootPageTree() {
    }

    public PRectangle getMediaBox() {
        return this.mediaBox;
    }

    public PRectangle getCropBox() {
        return this.cropBox;
    }

    public Resources getResources() {
        if (!this.loadedResources) {
            this.loadedResources = true;
            this.resources = this.library.getResources(this.entries, "Resources");
        }
        return this.resources;
    }

    public PageTree getParent() {
        return this.parent;
    }

    public int getPageNumber(Reference r) {
        Page pg = (Page)this.library.getObject(r);
        if (pg == null) {
            return -1;
        }
        int globalIndex = 0;
        Reference currChildRef = r;
        Reference currParentRef = pg.getParentReference();
        PageTree currParent = pg.getParent();
        while (currParentRef != null && currParent != null) {
            currParent.init();
            int refIndex = currParent.indexOfKidReference(currChildRef);
            if (refIndex < 0) {
                return -1;
            }
            int localIndex = 0;
            for (int i = 0; i < refIndex; ++i) {
                Object pageOrPages = currParent.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
                if (pageOrPages instanceof Page) {
                    ++localIndex;
                    continue;
                }
                if (!(pageOrPages instanceof PageTree)) continue;
                PageTree peerPageTree = (PageTree)pageOrPages;
                peerPageTree.init();
                localIndex += peerPageTree.getNumberOfPages();
            }
            globalIndex += localIndex;
            currChildRef = currParentRef;
            currParentRef = (Reference)currParent.entries.get("Parent");
            currParent = currParent.parent;
        }
        return globalIndex;
    }

    private int indexOfKidReference(Reference r) {
        for (int i = 0; i < this.kidsReferences.size(); ++i) {
            Reference ref = (Reference)this.kidsReferences.get(i);
            if (!ref.equals(r)) continue;
            return i;
        }
        return -1;
    }

    private Object getPageOrPagesPotentiallyNotInitedFromReferenceAt(int index) {
        Object pageOrPages = this.kidsPageAndPages.get(index);
        if (pageOrPages == null) {
            Reference ref = (Reference)this.kidsReferences.get(index);
            pageOrPages = this.library.getObject(ref);
            this.kidsPageAndPages.set(index, pageOrPages);
        }
        return pageOrPages;
    }

    private Page getPagePotentiallyNotInitedByRecursiveIndex(int globalIndex) {
        int globalIndexSoFar = 0;
        int numLocalKids = this.kidsPageAndPages.size();
        for (int i = 0; i < numLocalKids; ++i) {
            Object pageOrPages = this.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
            if (pageOrPages instanceof Page) {
                if (globalIndex == globalIndexSoFar) {
                    return (Page)pageOrPages;
                }
                ++globalIndexSoFar;
                continue;
            }
            if (!(pageOrPages instanceof PageTree)) continue;
            PageTree childPageTree = (PageTree)pageOrPages;
            childPageTree.init();
            int numChildPages = childPageTree.getNumberOfPages();
            if (globalIndex >= globalIndexSoFar && globalIndex < globalIndexSoFar + numChildPages) {
                return childPageTree.getPagePotentiallyNotInitedByRecursiveIndex(globalIndex - globalIndexSoFar);
            }
            globalIndexSoFar += numChildPages;
        }
        return null;
    }

    public int getNumberOfPages() {
        return this.kidsCount;
    }

    public Page getPage(int pageNumber, Object user) {
        if (pageNumber < 0) {
            return null;
        }
        Page p = this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
        if (p != null) {
            this.library.memoryManager.lock(user, p);
        }
        return p;
    }

    public Reference getPageReference(int pageNumber) {
        if (pageNumber < 0) {
            return null;
        }
        Page p = this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
        if (p != null) {
            return p.getPObjectReference();
        }
        return null;
    }

    public void releasePage(Page page, Object user) {
        if (this.library != null && this.library.memoryManager != null) {
            this.library.memoryManager.release(user, page);
        }
    }

    public void releasePage(int pageNumber, Object user) {
        Page page = this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
        this.library.memoryManager.release(user, page);
    }

    public String toString() {
        return "PAGES= " + this.entries.toString();
    }
}

