/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.TermFreqIterator;

public class FileDictionary
implements Dictionary {
    private BufferedReader in;
    private String line;
    private boolean hasNextCalled;

    public FileDictionary(InputStream dictFile) {
        this.in = new BufferedReader(new InputStreamReader(dictFile));
    }

    public FileDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    public TermFreqIterator getWordsIterator() {
        return new fileIterator();
    }

    final class fileIterator
    implements TermFreqIterator {
        private float curFreq;

        fileIterator() {
        }

        public String next() {
            if (!FileDictionary.this.hasNextCalled) {
                this.hasNext();
            }
            FileDictionary.this.hasNextCalled = false;
            return FileDictionary.this.line;
        }

        public float freq() {
            return this.curFreq;
        }

        public boolean hasNext() {
            FileDictionary.this.hasNextCalled = true;
            try {
                FileDictionary.this.line = FileDictionary.this.in.readLine();
                if (FileDictionary.this.line != null) {
                    String[] fields = FileDictionary.this.line.split("\t");
                    if (fields.length > 1) {
                        this.curFreq = Float.parseFloat(fields[1]);
                        FileDictionary.this.line = fields[0];
                    } else {
                        this.curFreq = 1.0f;
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return FileDictionary.this.line != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

