/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.faq.service.ObjectSearchResult;

public class AnswerSearchResult
implements Collection<ObjectSearchResult> {
    private final long offset;
    private final long limit;
    private final long totalSize;
    private long skip;
    private String[] ids;
    private String[] idsSkip;
    private List<ObjectSearchResult> gotList = null;

    public AnswerSearchResult(long offset, long limit, long totalSize) {
        this.offset = offset;
        this.limit = limit;
        this.totalSize = totalSize;
        this.ids = new String[0];
        this.idsSkip = new String[0];
        this.gotList = new ArrayList<ObjectSearchResult>();
        this.skip = 0L;
    }

    @Override
    public int size() {
        return this.gotList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.gotList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ObjectSearchResult) {
            ObjectSearchResult a = (ObjectSearchResult)o;
            return this.contains(a.getId());
        }
        return false;
    }

    public boolean contains(String id) {
        return ArrayUtils.indexOf((Object[])this.ids, (Object)id) >= 0;
    }

    public boolean addMore() {
        return (long)this.gotList.size() < this.limit && (long)this.gotList.size() < this.totalSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public Iterator<ObjectSearchResult> iterator() {
        return this.gotList.iterator();
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    private boolean contains(String[] skipList, Object o) {
        if (o instanceof ObjectSearchResult) {
            ObjectSearchResult a = (ObjectSearchResult)o;
            return ArrayUtils.indexOf((Object[])skipList, (Object)a.getId()) >= 0;
        }
        return false;
    }

    @Override
    public boolean add(ObjectSearchResult e) {
        if (this.contains(e)) {
            return false;
        }
        if (this.contains(this.idsSkip, e)) {
            return false;
        }
        if (++this.skip <= this.offset) {
            this.idsSkip = (String[])ArrayUtils.add((Object[])this.idsSkip, (Object)e.getId());
            return false;
        }
        this.ids = (String[])ArrayUtils.add((Object[])this.ids, (Object)e.getId());
        this.gotList.add(e);
        return true;
    }

    public List<ObjectSearchResult> result() {
        return this.gotList;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ObjectSearchResult) {
            ObjectSearchResult a = (ObjectSearchResult)o;
            this.ids = (String[])ArrayUtils.removeElement((Object[])this.ids, (Object)a.getId());
            return this.gotList.remove(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends ObjectSearchResult> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.ids = new String[0];
        this.gotList = new ArrayList<ObjectSearchResult>();
    }
}

