/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.LogWatchCallable;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.Processor;
import org.exoplatform.social.common.service.ServiceContext;
import org.exoplatform.social.common.service.SocialServiceExecutor;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.common.service.utils.AsyncProcessorTool;

public class SocialServiceExecutorImpl
implements SocialServiceExecutor {
    private ExecutorService executor;

    public SocialServiceExecutorImpl() {
    }

    public SocialServiceExecutorImpl(ExecutorService executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessContext execute(ServiceContext<ProcessContext> serviceContext, ProcessContext processContext) {
        processContext.getTraceElement().start();
        try {
            ProcessContext processContext2 = serviceContext.execute(processContext);
            return processContext2;
        }
        finally {
            processContext.getTraceElement().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessContext execute(Processor processor, ProcessContext processContext) {
        processContext.getTraceElement().start();
        try {
            ProcessContext processContext2 = processor.process(processContext);
            return processContext2;
        }
        finally {
            processContext.getTraceElement().end();
        }
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public Future<ProcessContext> asyncProcess(final AsyncProcessor asyncProcessor, final ProcessContext processorContext) {
        Callable<ProcessContext> task = new Callable<ProcessContext>(){

            @Override
            public ProcessContext call() throws Exception {
                return SocialServiceExecutorImpl.this.process(asyncProcessor, processorContext);
            }
        };
        if (SocialServiceContextImpl.getInstance().isTraced()) {
            task = new LogWatchCallable<ProcessContext>(task, processorContext.getTraceElement());
        }
        return this.getExecutorService().submit(task);
    }

    protected ProcessContext process(AsyncProcessor asyncProcessor, ProcessContext processorContext) throws Exception {
        AsyncProcessorTool.process(asyncProcessor, processorContext);
        return processorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (this.executor != null) {
            return this.executor;
        }
        SocialServiceExecutorImpl socialServiceExecutorImpl = this;
        synchronized (socialServiceExecutorImpl) {
            if (this.executor != null) {
                return this.executor;
            }
            this.executor = SocialServiceContextImpl.getInstance().getExecutorServiceManager().newDefaultThreadPool("DefaultSocialExecutor");
        }
        return this.executor;
    }

    @Override
    public ProcessContext async(AsyncProcessor asyncProcessor, ProcessContext processContext) {
        Future<ProcessContext> future = this.asyncProcess(asyncProcessor, processContext);
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            return future.get();
        }
        catch (InterruptedException e) {
            processContext.setException(e);
        }
        catch (ExecutionException e) {
            processContext.setException(e);
        }
        catch (TimeoutException e) {
            processContext.setException(e);
        }
        return processContext;
    }

    @Override
    public ProcessContext async(final AsyncProcessor asyncProcessor, final ProcessContext processContext, final AsyncCallback callback) {
        Callable<ProcessContext> task = new Callable<ProcessContext>(){

            @Override
            public ProcessContext call() throws Exception {
                return asyncProcessor.process(processContext, callback);
            }
        };
        if (SocialServiceContextImpl.getInstance().isTraced()) {
            task = new LogWatchCallable<ProcessContext>(task, processContext.getTraceElement());
        }
        Future<ProcessContext> future = this.getExecutorService().submit(task);
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            return future.get();
        }
        catch (InterruptedException e) {
            processContext.setException(e);
        }
        catch (ExecutionException e) {
            processContext.setException(e);
        }
        catch (TimeoutException e) {
            processContext.setException(e);
        }
        return processContext;
    }
}

