/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.impl;

import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.application.registry.impl.CategoryDefinition;

@PrimaryType(name="app:applicationregistry")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="app")
public abstract class ContentRegistry {
    @OneToMany
    public abstract List<CategoryDefinition> getCategoryList();

    @OneToMany
    public abstract Map<String, CategoryDefinition> getCategoryMap();

    @Create
    public abstract CategoryDefinition create();

    public CategoryDefinition getCategory(String categoryName) {
        Map<String, CategoryDefinition> categories = this.getCategoryMap();
        return categories.get(categoryName);
    }

    public CategoryDefinition createCategory(String categoryName) {
        Map<String, CategoryDefinition> categories = this.getCategoryMap();
        if (categories.containsKey(categoryName)) {
            throw new IllegalArgumentException("Duplicate category " + categoryName);
        }
        CategoryDefinition category = this.create();
        categories.put(categoryName, category);
        return category;
    }
}

