/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.include;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.macro.include.IncludePageMacroParameters;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wiki.WikiModel;

@Component(value="includepage")
public class IncludePageMacro
extends AbstractMacro<IncludePageMacroParameters> {
    private static final String DESCRIPTION = "Includes the contents of a page within current";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;

    public IncludePageMacro() {
        super("Include Page", DESCRIPTION, IncludePageMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(IncludePageMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        StringBuilder includeContent = new StringBuilder();
        ExecutionContext ec = this.execution.getContext();
        WikiContext currentCtx = (WikiContext)ec.getProperty("wikicontext");
        WikiContext includeCtx = currentCtx.clone();
        WikiPageParams includeParams = this.markupContextManager.getMarkupContext(parameters.getPage(), ResourceType.DOCUMENT);
        PageImpl page = null;
        try {
            page = (PageImpl)this.getWikiService().getPageById(includeParams.getType(), includeParams.getOwner(), includeParams.getPageId());
            PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
            renderingCacheService.addPageLink(new WikiPageParams(currentCtx.getType(), currentCtx.getOwner(), currentCtx.getPageId()), new WikiPageParams(includeParams.getType(), includeParams.getOwner(), includeParams.getPageId()));
            if (page == null) {
                return Collections.emptyList();
            }
            includeParams = new WikiPageParams(includeParams.getType(), includeParams.getOwner(), page.getName());
        }
        catch (Exception e) {
            throw new MacroExecutionException(String.format("Failed to resolve page [%s.%s:%s]", currentCtx.getType(), currentCtx.getOwner(), currentCtx.getPageTitle()));
        }
        if (this.isRecursiveInclude(currentCtx, includeParams)) {
            throw new MacroExecutionException(String.format("Found recursive inclusion of page [%s.%s:%s]", currentCtx.getType(), currentCtx.getOwner(), currentCtx.getPageTitle()));
        }
        try {
            includeCtx.includePageCtx.add(includeParams);
            ec.setProperty("wikicontext", (Object)includeCtx);
            if (page != null) {
                includeContent.append("<div class=\"IncludePage \" >");
                includeContent.append(this.getRenderingService().render(page.getContent().getText(), page.getSyntax(), Syntax.XHTML_1_0.toIdString(), false));
                includeContent.append("</div>");
            }
            RawBlock result = new RawBlock(includeContent.toString(), Syntax.XHTML_1_0);
            List<RawBlock> list = Collections.singletonList(result);
            return list;
        }
        catch (Exception e) {
            throw new MacroExecutionException(String.format("Failed to render include page's content [%s.%s:%s]", currentCtx.getType(), currentCtx.getOwner(), currentCtx.getPageTitle()));
        }
        finally {
            ec.setProperty("wikicontext", (Object)currentCtx);
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected WikiModel getWikiModel(MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (WikiModel)this.getComponentManager().getInstance(WikiModel.class);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find wiki model", (Throwable)e);
        }
    }

    protected RenderingService getRenderingService() {
        return (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
    }

    protected WikiService getWikiService() {
        return (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
    }

    private boolean isRecursiveInclude(WikiContext context, WikiPageParams params) {
        return context.includePageCtx.contains(params);
    }
}

